/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class PrivateKeyInfoTest
extends SimpleTest {
    private static final byte[] priv = Base64.decode("MC4CAQAwBQYDK2VwBCIEINTuctv5E1hK1bbY8fdp+K06/nwoy/HU++CXqI9EdVhC");
    private static final byte[] privWithPub = Base64.decode("MHICAQEwBQYDK2VwBCIEINTuctv5E1hK1bbY8fdp+K06/nwoy/HU++CXqI9EdVhCoB8wHQYKKoZIhvcNAQkJFDEPDA1DdXJkbGUgQ2hhaXJzgSEAGb9ECWmEzf6FQbrBZ9w7lshQhqowtrbLDFw4rXAxZuE=");

    public String getName() {
        return "PrivateKeyInfoTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new PrivateKeyInfoTest());
    }

    public void performTest() throws Exception {
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(priv);
        this.isTrue(privateKeyInfo.hasPublicKey() ^ true);
        PrivateKeyInfo privateKeyInfo2 = new PrivateKeyInfo(privateKeyInfo.getPrivateKeyAlgorithm(), privateKeyInfo.parsePrivateKey());
        this.isTrue("enc 1 failed", this.areEqual(priv, privateKeyInfo2.getEncoded()));
        privateKeyInfo = PrivateKeyInfo.getInstance(privWithPub);
        this.isTrue(privateKeyInfo.hasPublicKey());
        privateKeyInfo2 = new PrivateKeyInfo(privateKeyInfo.getPrivateKeyAlgorithm(), privateKeyInfo.parsePrivateKey(), privateKeyInfo.getAttributes(), privateKeyInfo.getPublicKeyData().getOctets());
        this.isTrue("enc 2 failed", this.areEqual(privWithPub, privateKeyInfo2.getEncoded()));
    }
}

