/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class PolicyConstraintsTest
extends SimpleTest {
    public String getName() {
        return "PolicyConstraints";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new PolicyConstraintsTest());
    }

    public void performTest() throws Exception {
        PolicyConstraints policyConstraints = new PolicyConstraints(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        PolicyConstraints policyConstraints2 = PolicyConstraints.getInstance(policyConstraints.getEncoded());
        this.isTrue("1 requireExplicitPolicyMapping", policyConstraints2.getRequireExplicitPolicyMapping().equals(BigInteger.valueOf(1L)));
        this.isTrue("2 inhibitPolicyMapping", policyConstraints2.getInhibitPolicyMapping().equals(BigInteger.valueOf(2L)));
        policyConstraints = new PolicyConstraints(BigInteger.valueOf(3L), null);
        policyConstraints2 = PolicyConstraints.getInstance(policyConstraints.getEncoded());
        this.isTrue("3 requireExplicitPolicyMapping", policyConstraints2.getRequireExplicitPolicyMapping().equals(BigInteger.valueOf(3L)));
        this.isTrue("4 inhibitPolicyMapping", policyConstraints2.getInhibitPolicyMapping() == null);
        policyConstraints = new PolicyConstraints(null, BigInteger.valueOf(4L));
        policyConstraints2 = PolicyConstraints.getInstance(policyConstraints.getEncoded());
        this.isTrue("5 inhibitPolicyMapping", policyConstraints2.getInhibitPolicyMapping().equals(BigInteger.valueOf(4L)));
        this.isTrue("6 requireExplicitPolicyMapping", policyConstraints2.getRequireExplicitPolicyMapping() == null);
        this.isTrue("encoding test", Arrays.areEqual(new PolicyConstraints(BigInteger.valueOf(1L), null).getEncoded(), new DERSequence(new DERTaggedObject(false, 0, (ASN1Encodable)new ASN1Integer(1L))).getEncoded()));
    }
}

