/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class OIDTest
extends SimpleTest {
    byte[] req1 = Hex.decode("0603813403");
    byte[] req2 = Hex.decode("06082A36FFFFFFDD6311");

    private void branchCheck(String string, String string2) {
        String string3;
        String string4 = String.valueOf(string) + "." + string2;
        if (!string4.equals(string3 = new ASN1ObjectIdentifier(string).branch(string2).getId())) {
            this.fail("failed 'branch' check for " + string + "/" + string2);
        }
    }

    public String getName() {
        return "OID";
    }

    private void invalidOidCheck(String string) {
        this.isTrue(ASN1ObjectIdentifier.tryFromID(string) == null);
        try {
            new ASN1ObjectIdentifier(string);
            this.fail("failed to catch bad oid: " + string);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new OIDTest());
    }

    private void onCheck(String string, String string2, boolean bl) {
        if (bl != new ASN1ObjectIdentifier(string2).on(new ASN1ObjectIdentifier(string))) {
            this.fail("failed 'on' check for " + string + "/" + string2);
        }
    }

    public void performTest() throws IOException {
        this.recodeCheck("2.100.3", this.req1);
        this.recodeCheck("1.2.54.34359733987.17", this.req2);
        this.validOidCheck(PKCSObjectIdentifiers.pkcs_9_at_contentType.getId());
        this.validOidCheck("0.1");
        this.validOidCheck("1.0");
        this.validOidCheck("1.0.2");
        this.validOidCheck("1.0.20");
        this.validOidCheck("1.0.200");
        this.validOidCheck("1.1.127.32512.8323072.2130706432.545460846592.139637976727552.35747322042253312.9151314442816847872");
        this.validOidCheck("1.2.123.12345678901.1.1.1");
        this.validOidCheck("2.25.196556539987194312349856245628873852187.1");
        this.validOidCheck("0.0");
        this.validOidCheck("0.0.1");
        this.validOidCheck("0.39");
        this.validOidCheck("0.39.1");
        this.validOidCheck("1.0");
        this.validOidCheck("1.0.1");
        this.validOidCheck("1.39");
        this.validOidCheck("1.39.1");
        this.validOidCheck("2.0");
        this.validOidCheck("2.0.1");
        this.validOidCheck("2.40");
        this.validOidCheck("2.40.1");
        this.invalidOidCheck("0");
        this.invalidOidCheck("1");
        this.invalidOidCheck("2");
        this.invalidOidCheck("3.1");
        this.invalidOidCheck("0.01");
        this.invalidOidCheck("00.1");
        this.invalidOidCheck("1.00.2");
        this.invalidOidCheck("1.0.02");
        this.invalidOidCheck("1.2.00");
        this.invalidOidCheck("..1");
        this.invalidOidCheck("192.168.1.1");
        this.invalidOidCheck(".123452");
        this.invalidOidCheck("1.");
        this.invalidOidCheck("1.345.23.34..234");
        this.invalidOidCheck("1.345.23.34.234.");
        this.invalidOidCheck(".12.345.77.234");
        this.invalidOidCheck(".12.345.77.234.");
        this.invalidOidCheck("1.2.3.4.A.5");
        this.invalidOidCheck("1,2");
        this.invalidOidCheck("0.40");
        this.invalidOidCheck("0.40.1");
        this.invalidOidCheck("0.100");
        this.invalidOidCheck("0.100.1");
        this.invalidOidCheck("1.40");
        this.invalidOidCheck("1.40.1");
        this.invalidOidCheck("1.100");
        this.invalidOidCheck("1.100.1");
        this.branchCheck("1.1", "2.2");
        this.onCheck("1.1", "1.1", false);
        this.onCheck("1.1", "1.2", false);
        this.onCheck("1.1", "1.2.1", false);
        this.onCheck("1.1", "2.1", false);
        this.onCheck("1.1", "1.11", false);
        this.onCheck("1.12", "1.1.2", false);
        this.onCheck("1.1", "1.1.1", true);
        this.onCheck("1.1", "1.1.2", true);
        this.onCheck("1.2.3.4.5.6", "1.2.3.4.5.6", false);
        this.onCheck("1.2.3.4.5.6", "1.2.3.4.5.6.7", true);
        this.onCheck("1.2.3.4.5.6", "1.2.3.4.5.6.7.8", true);
        this.testIntern();
    }

    private void recodeCheck(String string, byte[] byArray) throws IOException {
        byte[] byArray2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)aSN1InputStream.readObject();
        if (!aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2)) {
            this.fail("oid ID didn't match", aSN1ObjectIdentifier, aSN1ObjectIdentifier2);
        }
        if ((byArray2 = aSN1ObjectIdentifier.getEncoded("DER")).length != byArray.length) {
            this.fail("failed length test");
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray2[n] != byArray[n]) {
                this.fail("failed comparison test", new String(Hex.encode(byArray)), new String(Hex.encode(byArray2)));
            }
            ++n;
        }
    }

    private void testIntern() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("2.2.100").intern();
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier("2.2.100").intern();
        this.isTrue(aSN1ObjectIdentifier2 != null);
        this.isEquals(aSN1ObjectIdentifier, aSN1ObjectIdentifier2);
    }

    private void validOidCheck(String string) throws IOException {
        this.isTrue(ASN1ObjectIdentifier.tryFromID(string) != null);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
        aSN1ObjectIdentifier = (ASN1ObjectIdentifier)ASN1Primitive.fromByteArray(aSN1ObjectIdentifier.getEncoded());
        if (!aSN1ObjectIdentifier.getId().equals(string)) {
            this.fail("failed oid check for " + string);
        }
    }
}

