/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.internal.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.internal.asn1.misc.IDEACBCPar;
import org.bouncycastle.internal.asn1.misc.NetscapeCertType;
import org.bouncycastle.internal.asn1.misc.NetscapeRevocationURL;
import org.bouncycastle.internal.asn1.misc.VerisignCzagExtension;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class MiscTest
extends SimpleTest {
    public void asn1IntegerTest() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] byArray = new byte[4];
            byArray[3] = 1;
            new ASN1Integer(byArray);
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong exc 1: " + illegalArgumentException.getMessage(), "malformed integer".equals(illegalArgumentException.getMessage()));
        }
        try {
            byte[] byArray = new byte[4];
            byArray[0] = -1;
            byArray[1] = -128;
            byArray[3] = 1;
            new ASN1Integer(byArray);
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong exc 2: " + illegalArgumentException.getMessage(), "malformed integer".equals(illegalArgumentException.getMessage()));
        }
        try {
            byte[] byArray = new byte[4];
            byArray[3] = 1;
            new ASN1Enumerated(byArray);
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong exc 3: " + illegalArgumentException.getMessage(), "malformed enumerated".equals(illegalArgumentException.getMessage()));
        }
        try {
            byte[] byArray = new byte[4];
            byArray[0] = -1;
            byArray[1] = -128;
            byArray[3] = 1;
            new ASN1Enumerated(byArray);
            this.fail("expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue("wrong exc 4: " + illegalArgumentException.getMessage(), "malformed enumerated".equals(illegalArgumentException.getMessage()));
        }
    }

    public String getName() {
        return "Misc";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new MiscTest());
    }

    public void performTest() throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{new CAST5CBCParameters(byArray, 128), new NetscapeCertType(32), new VerisignCzagExtension(new DERIA5String("hello")), new IDEACBCPar(byArray), new NetscapeRevocationURL(new DERIA5String("http://test"))};
        byte[] byArray2 = Base64.decode("MA4ECAECAwQFBgcIAgIAgAMCBSAWBWhlbGxvMAoECAECAwQFBgcIFgtodHRwOi8vdGVzdA==");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream);
        int n = 0;
        while (n != aSN1EncodableArray.length) {
            aSN1OutputStream.writeObject(aSN1EncodableArray[n]);
            ++n;
        }
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), byArray2)) {
            this.fail("Failed data check");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray2);
        int n2 = 0;
        while (n2 != aSN1EncodableArray.length) {
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            if (!aSN1EncodableArray[n2].equals(aSN1Primitive)) {
                this.fail("Failed equality test for " + aSN1Primitive);
            }
            if (aSN1Primitive.hashCode() != aSN1EncodableArray[n2].hashCode()) {
                this.fail("Failed hashCode test for " + aSN1Primitive);
            }
            ++n2;
        }
        this.shouldFailOnExtraData();
        this.asn1IntegerTest();
    }

    public void shouldFailOnExtraData() throws Exception {
        block2: {
            DERBitString dERBitString = new DERBitString(new byte[0], 0);
            ASN1Primitive.fromByteArray(dERBitString.getEncoded());
            ASN1Primitive.fromByteArray(new BERSequence(dERBitString).getEncoded());
            try {
                ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(Arrays.concatenate(dERBitString.getEncoded(), new byte[1]));
                this.fail("no exception");
            }
            catch (IOException iOException) {
                if ("Extra data detected in stream".equals(iOException.getMessage())) break block2;
                this.fail("wrong exception");
            }
        }
    }
}

