/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.bc.LinkedCertificate;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.test.ASN1UnitTest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.util.test.SimpleTest;

public class LinkedCertificateTest
extends ASN1UnitTest {
    private void checkConstruction(LinkedCertificate linkedCertificate, DigestInfo digestInfo, GeneralName generalName, X500Name x500Name, GeneralNames generalNames) throws IOException {
        this.checkValues(linkedCertificate, digestInfo, generalName, x500Name, generalNames);
        linkedCertificate = LinkedCertificate.getInstance(linkedCertificate);
        this.checkValues(linkedCertificate, digestInfo, generalName, x500Name, generalNames);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(linkedCertificate.toASN1Primitive().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        linkedCertificate = LinkedCertificate.getInstance(aSN1Sequence);
        this.checkValues(linkedCertificate, digestInfo, generalName, x500Name, generalNames);
    }

    private void checkValues(LinkedCertificate linkedCertificate, DigestInfo digestInfo, GeneralName generalName, X500Name x500Name, GeneralNames generalNames) {
        this.checkMandatoryField("digest", digestInfo, linkedCertificate.getDigest());
        this.checkMandatoryField("certLocatin", generalName, linkedCertificate.getCertLocation());
        this.checkOptionalField("certIssuer", x500Name, linkedCertificate.getCertIssuer());
        this.checkOptionalField("caCerts", generalNames, linkedCertificate.getCACerts());
    }

    public String getName() {
        return "LinkedCertificate";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new LinkedCertificateTest());
    }

    public void performTest() throws Exception {
        DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), new byte[32]);
        GeneralName generalName = new GeneralName(6, "https://www.bouncycastle.org/certs");
        X500Name x500Name = null;
        GeneralNames generalNames = null;
        LinkedCertificate linkedCertificate = new LinkedCertificate(digestInfo, generalName);
        this.checkConstruction(linkedCertificate, digestInfo, generalName, x500Name, generalNames);
        x500Name = new X500Name("CN=Test");
        generalNames = new GeneralNames(new GeneralName(new X500Name("CN=CA Test")));
        linkedCertificate = new LinkedCertificate(digestInfo, generalName, x500Name, generalNames);
        this.checkConstruction(linkedCertificate, digestInfo, generalName, x500Name, generalNames);
        linkedCertificate = LinkedCertificate.getInstance(null);
        if (linkedCertificate != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            LinkedCertificate.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

