/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.KMACwithSHAKE128_params;
import org.bouncycastle.asn1.nist.KMACwithSHAKE256_params;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class KMACParamsTest
extends SimpleTest {
    public String getName() {
        return "KMACParams";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new KMACParamsTest());
    }

    public void performTest() throws Exception {
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(256).getEncoded(), new DERSequence().getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(512).getEncoded(), new DERSequence().getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(512).getEncoded(), new DERSequence(new ASN1Integer(512L)).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(256).getEncoded(), new DERSequence(new ASN1Integer(256L)).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(512).getEncoded(), KMACwithSHAKE128_params.getInstance(new DERSequence(new ASN1Integer(512L))).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(256).getEncoded(), KMACwithSHAKE256_params.getInstance(new DERSequence(new ASN1Integer(256L))).getEncoded()));
        byte[] byArray = Strings.toByteArray("hello, world!");
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(512, byArray).getEncoded(), new DERSequence(new ASN1Encodable[]{new ASN1Integer(512L), new DEROctetString(byArray)}).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(256, byArray).getEncoded(), new DERSequence(new ASN1Encodable[]{new ASN1Integer(256L), new DEROctetString(byArray)}).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(512, byArray).getEncoded(), KMACwithSHAKE128_params.getInstance(new DERSequence(new ASN1Encodable[]{new ASN1Integer(512L), new DEROctetString(byArray)})).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(256, byArray).getEncoded(), KMACwithSHAKE256_params.getInstance(new DERSequence(new ASN1Encodable[]{new ASN1Integer(256L), new DEROctetString(byArray)})).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(256, byArray).getEncoded(), new DERSequence(new ASN1Encodable[]{new DEROctetString(byArray)}).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(512, byArray).getEncoded(), new DERSequence(new ASN1Encodable[]{new DEROctetString(byArray)}).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE128_params(256, byArray).getEncoded(), KMACwithSHAKE128_params.getInstance(new DERSequence(new ASN1Encodable[]{new DEROctetString(byArray)})).getEncoded()));
        this.isTrue(Arrays.areEqual(new KMACwithSHAKE256_params(512, byArray).getEncoded(), KMACwithSHAKE256_params.getInstance(new DERSequence(new ASN1Encodable[]{new DEROctetString(byArray)})).getEncoded()));
        KMACwithSHAKE128_params kMACwithSHAKE128_params = new KMACwithSHAKE128_params(256, byArray);
        this.isEquals(256, kMACwithSHAKE128_params.getOutputLength());
        this.isTrue(Arrays.areEqual(byArray, kMACwithSHAKE128_params.getCustomizationString()));
        this.isTrue(kMACwithSHAKE128_params == KMACwithSHAKE128_params.getInstance(kMACwithSHAKE128_params));
        KMACwithSHAKE256_params kMACwithSHAKE256_params = new KMACwithSHAKE256_params(512, byArray);
        this.isEquals(512, kMACwithSHAKE256_params.getOutputLength());
        this.isTrue(Arrays.areEqual(byArray, kMACwithSHAKE256_params.getCustomizationString()));
        this.isTrue(kMACwithSHAKE256_params == KMACwithSHAKE256_params.getInstance(kMACwithSHAKE256_params));
        kMACwithSHAKE128_params = new KMACwithSHAKE128_params(512);
        this.isEquals(512, kMACwithSHAKE128_params.getOutputLength());
        this.isTrue(Arrays.areEqual(new byte[0], kMACwithSHAKE128_params.getCustomizationString()));
        kMACwithSHAKE256_params = new KMACwithSHAKE256_params(256);
        this.isEquals(256, kMACwithSHAKE256_params.getOutputLength());
        this.isTrue(Arrays.areEqual(new byte[0], kMACwithSHAKE256_params.getCustomizationString()));
    }
}

