/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class InputStreamTest
extends SimpleTest {
    private static final byte[] outOfBoundsLength = new byte[]{48, -1, -1, -1, -1, -1};
    private static final byte[] negativeLength = new byte[]{48, -124, -1, -1, -1, -1};
    private static final byte[] outsideLimitLength = new byte[]{48, -125, 15, -1, -1};
    private static final byte[] classCast1 = Base64.decode("p1AkHmYAvfOEIrL4ESfrNg==");
    private static final byte[] classCast2 = Base64.decode("JICNbaBUTTq7uxj5mg==");
    private static final byte[] classCast3 = Base64.decode("JAKzADNCxhrrBSVS");
    private static final byte[] memoryError1 = Base64.decode("vm66gOiEe+FV/NvujMwSkUp5Lffw5caQlaRU5sdMPC70IGWmyK2/");
    private static final byte[] memoryError2 = Base64.decode("vm4ogOSEfVGsS3w+KTzb2A0ALYR8VBOQqQeuRwnsPC4AAGWEDLjd");

    public String getName() {
        return "InputStream";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new InputStreamTest());
    }

    public void performTest() throws Exception {
        block8: {
            ASN1InputStream aSN1InputStream;
            block7: {
                block6: {
                    aSN1InputStream = new ASN1InputStream(outOfBoundsLength);
                    try {
                        aSN1InputStream.readObject();
                        this.fail("out of bounds length not detected.");
                    }
                    catch (IOException iOException) {
                        if (iOException.getMessage().startsWith("invalid long form definite-length 0xFF")) break block6;
                        this.fail("wrong exception: " + iOException.getMessage());
                    }
                }
                aSN1InputStream = new ASN1InputStream(negativeLength);
                try {
                    aSN1InputStream.readObject();
                    this.fail("negative length not detected.");
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().equals("long form definite-length more than 31 bits")) break block7;
                    this.fail("wrong exception: " + iOException.getMessage());
                }
            }
            aSN1InputStream = new ASN1InputStream(outsideLimitLength);
            try {
                aSN1InputStream.readObject();
                this.fail("outside limit length not detected.");
            }
            catch (IOException iOException) {
                if (iOException.getMessage().equals("corrupted stream - out of bounds length found: 1048575 >= 5")) break block8;
                this.fail("wrong exception: " + iOException.getMessage());
            }
        }
        this.testWithByteArray(classCast2, "unknown object encountered: class org.bouncycastle.asn1.DLTaggedObjectParser");
        this.testWithByteArray(classCast3, "unknown object encountered in constructed OCTET STRING: class org.bouncycastle.asn1.DLTaggedObject");
    }

    private void testWithByteArray(byte[] byArray, String string) {
        try {
            ASN1Primitive aSN1Primitive;
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            while ((aSN1Primitive = aSN1InputStream.readObject()) != null) {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Primitive);
                int n = 0;
                while (n < aSN1Sequence.size()) {
                    aSN1Sequence.getObjectAt(n);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            this.isEquals(iOException.getMessage(), string, iOException.getMessage());
        }
    }
}

