/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class CertIDTest
extends SimpleTest {
    public String getName() {
        return "CertID";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new CertIDTest());
    }

    public void performTest() throws Exception {
        DEROctetString dEROctetString = new DEROctetString(Strings.toByteArray("IssuerAHash"));
        DEROctetString dEROctetString2 = new DEROctetString(Strings.toByteArray("IssuerBHash"));
        DEROctetString dEROctetString3 = new DEROctetString(Strings.toByteArray("IssuerAKeyHash"));
        DEROctetString dEROctetString4 = new DEROctetString(Strings.toByteArray("IssuerBKeyHash"));
        CertID certID = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), dEROctetString, dEROctetString3, new ASN1Integer(BigIntegers.ONE));
        CertID certID2 = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE), dEROctetString, dEROctetString3, new ASN1Integer(BigIntegers.ONE));
        CertID certID3 = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DEROctetString(new byte[1])), dEROctetString, dEROctetString3, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(certID.equals(certID));
        this.isTrue(certID.equals(certID2));
        this.isTrue(certID.hashCode() == certID2.hashCode());
        this.isTrue(certID.equals(certID3) ^ true);
        this.isTrue(certID.hashCode() != certID3.hashCode());
        certID2 = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), dEROctetString, dEROctetString3, new ASN1Integer(BigIntegers.TWO));
        this.isTrue(certID.equals(certID2) ^ true);
        certID2 = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm), dEROctetString, dEROctetString3, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(certID.equals(certID2) ^ true);
        certID2 = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), dEROctetString2, dEROctetString3, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(certID.equals(certID2) ^ true);
        certID2 = new CertID(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), dEROctetString, dEROctetString4, new ASN1Integer(BigIntegers.ONE));
        this.isTrue(certID.equals(certID2) ^ true);
    }
}

