/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.BERBitString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;

public class BitStringTest
extends SimpleTest {
    private void encodingCheck(byte[] byArray, byte[] byArray2) throws IOException {
        if (Arrays.areEqual(byArray, ASN1Primitive.fromByteArray(byArray2).getEncoded())) {
            this.fail("failed DL check");
        }
        ASN1BitString aSN1BitString = ASN1BitString.getInstance(byArray2);
        this.isTrue("DL test failed", aSN1BitString instanceof DLBitString);
        if (!Arrays.areEqual(byArray, ASN1Primitive.fromByteArray(byArray2).getEncoded("DER"))) {
            this.fail("failed DER check");
        }
        try {
            ASN1BitString.getInstance(byArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fail("failed DL encoding conversion");
        }
        ASN1BitString aSN1BitString2 = ASN1BitString.getInstance(byArray);
        this.isTrue("DER test failed", aSN1BitString2 instanceof DERBitString);
    }

    public String getName() {
        return "BitString";
    }

    public static void main(String[] stringArray) {
        BitStringTest bitStringTest = new BitStringTest();
        TestResult testResult = bitStringTest.perform();
        System.out.println(testResult);
    }

    public void performTest() throws Exception {
        KeyUsage keyUsage = new KeyUsage(128);
        if (keyUsage.getBytes()[0] != -128 || keyUsage.getPadBits() != 7) {
            this.fail("failed digitalSignature");
        }
        if ((keyUsage = new KeyUsage(64)).getBytes()[0] != 64 || keyUsage.getPadBits() != 6) {
            this.fail("failed nonRepudiation");
        }
        if ((keyUsage = new KeyUsage(32)).getBytes()[0] != 32 || keyUsage.getPadBits() != 5) {
            this.fail("failed keyEncipherment");
        }
        if ((keyUsage = new KeyUsage(2)).getBytes()[0] != 2 || keyUsage.getPadBits() != 1) {
            this.fail("failed cRLSign");
        }
        if ((keyUsage = new KeyUsage(32768)).getBytes()[1] != -128 || keyUsage.getPadBits() != 7) {
            this.fail("failed decipherOnly");
        }
        try {
            ASN1Primitive.fromByteArray(new DERBitString(new byte[0], 0).getEncoded());
        }
        catch (IOException iOException) {
            this.fail(iOException.toString());
        }
        this.testConstructed();
        this.testRandomPadBits();
        this.testZeroLengthStrings();
    }

    private void testConstructed() throws Exception {
        BERBitString bERBitString = new BERBitString(new byte[1500], 1);
        ASN1BitString aSN1BitString = ASN1BitString.getInstance(bERBitString.getEncoded());
    }

    private void testRandomPadBits() throws Exception {
        byte[] byArray = Hex.decode("030206c0");
        byte[] byArray2 = Hex.decode("030206f0");
        byte[] byArray3 = Hex.decode("030206c1");
        byte[] byArray4 = Hex.decode("030206c7");
        byte[] byArray5 = Hex.decode("030206d1");
        this.encodingCheck(byArray, byArray2);
        this.encodingCheck(byArray, byArray3);
        this.encodingCheck(byArray, byArray4);
        this.encodingCheck(byArray, byArray5);
    }

    private void testZeroLengthStrings() throws Exception {
        DERBitString dERBitString;
        block10: {
            block9: {
                block8: {
                    dERBitString = new DERBitString(new byte[0], 0);
                    dERBitString.getBytes();
                    DERBitString dERBitString2 = (DERBitString)ASN1Primitive.fromByteArray(dERBitString.getEncoded());
                    if (!Arrays.areEqual(dERBitString.getEncoded(), Hex.decode("030100"))) {
                        this.fail("zero encoding wrong");
                    }
                    try {
                        new DERBitString(null, 1);
                        this.fail("exception not thrown");
                    }
                    catch (NullPointerException nullPointerException) {
                        if ("'data' cannot be null".equals(((Throwable)nullPointerException).getMessage())) break block8;
                        this.fail("Unexpected exception: " + ((Throwable)nullPointerException).getMessage());
                    }
                }
                try {
                    new DERBitString(new byte[0], 1);
                    this.fail("exception not thrown");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("zero length data with non-zero pad bits".equals(illegalArgumentException.getMessage())) break block9;
                    this.fail("Unexpected exception");
                }
            }
            try {
                new DERBitString(new byte[1], 8);
                this.fail("exception not thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("pad bits cannot be greater than 7 or less than 0".equals(illegalArgumentException.getMessage())) break block10;
                this.fail("Unexpected exception");
            }
        }
        DERBitString dERBitString3 = new DERBitString(0);
        if (!Arrays.areEqual(dERBitString.getEncoded(), dERBitString3.getEncoded())) {
            this.fail("zero encoding wrong");
        }
    }
}

