/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.math.BigInteger;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ASN1IntegerTest
extends SimpleTest {
    private static final byte[] suspectKey = Base64.decode("MIGJAoGBAHNc+iExm94LUrJdPSJ4QJ9tDRuvaNmGVHpJ4X7a5zKI02v+2E7RotuiR2MHDJfVJkb9LUs2kb3XBlyENhtMLsbeH+3Muy3hGDlh/mLJSh1s4c5jDKBRYOHom7Uc8wP0P2+zBCA+OEdikNDFBaP5PbR2Xq9okG2kPh35M2quAiMTAgMBAAE=");

    private void checkIntValue(ASN1Integer aSN1Integer, int n) {
        BigInteger bigInteger = aSN1Integer.getValue();
        this.isEquals(bigInteger.intValue(), n);
        this.isEquals(BigIntegers.intValueExact(bigInteger), n);
        this.isEquals(aSN1Integer.intValueExact(), n);
        this.isTrue(aSN1Integer.hasValue(n));
    }

    private void checkLongValue(ASN1Integer aSN1Integer, long l) {
        BigInteger bigInteger = aSN1Integer.getValue();
        this.isEquals(bigInteger.longValue(), l);
        this.isEquals(BigIntegers.longValueExact(bigInteger), l);
        this.isEquals(aSN1Integer.longValueExact(), l);
        this.isTrue(aSN1Integer.hasValue(l));
    }

    public String getName() {
        return "ASN1Integer";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ASN1IntegerTest());
    }

    public void performTest() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        ASN1Sequence.getInstance(suspectKey);
        this.testValidEncodingSingleByte();
        this.testValidEncodingMultiByte();
        this.testInvalidEncoding_00();
        this.testInvalidEncoding_ff();
        this.testInvalidEncoding_00_32bits();
        this.testInvalidEncoding_ff_32bits();
        this.testLooseValidEncoding_zero_32BAligned();
        this.testLooseValidEncoding_FF_32BAligned();
        this.testLooseValidEncoding_FF_32BAligned_1not0();
        this.testLooseValidEncoding_FF_32BAligned_2not0();
        this.testOversizedEncoding();
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
        new ASN1Enumerated(Hex.decode("005a47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
        this.isTrue(Properties.setThreadOverride("org.bouncycastle.asn1.allow_unsafe_integer", true) ^ true);
        new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b"));
        this.isTrue(Properties.removeThreadOverride("org.bouncycastle.asn1.allow_unsafe_integer"));
        try {
            ASN1Sequence.getInstance(suspectKey);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("test 1: " + illegalArgumentException.getMessage(), "failed to construct sequence from byte[]: malformed integer", illegalArgumentException.getMessage());
        }
        try {
            new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
        try {
            new ASN1Enumerated(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed enumerated", illegalArgumentException.getMessage());
        }
        try {
            new ASN1Enumerated(Hex.decode("005a47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed enumerated", illegalArgumentException.getMessage());
        }
    }

    public void testInvalidEncoding_00() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] byArray = Hex.decode("0010FF");
            new ASN1Integer(byArray);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
    }

    public void testInvalidEncoding_00_32bits() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] byArray = Hex.decode("0000000010FF");
            new ASN1Integer(byArray);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
    }

    public void testInvalidEncoding_ff() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] byArray = Hex.decode("FF81FF");
            new ASN1Integer(byArray);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
    }

    public void testInvalidEncoding_ff_32bits() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        try {
            byte[] byArray = Hex.decode("FFFFFFFF01FF");
            new ASN1Integer(byArray);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
    }

    public void testLooseValidEncoding_FF_32BAligned() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] byArray = Hex.decode("FFFFFF10FF000000");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.checkLongValue(aSN1Integer, -1026513960960L);
    }

    public void testLooseValidEncoding_FF_32BAligned_1not0() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] byArray = Hex.decode("FFFEFF10FF000000");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.checkLongValue(aSN1Integer, -282501490671616L);
    }

    public void testLooseValidEncoding_FF_32BAligned_2not0() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] byArray = Hex.decode("FFFFFE10FF000000");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.checkLongValue(aSN1Integer, -2126025588736L);
    }

    public void testLooseValidEncoding_zero_32BAligned() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] byArray = Hex.decode("00000010FF000000");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.checkLongValue(aSN1Integer, 0x10FF000000L);
    }

    public void testOversizedEncoding() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        ((Hashtable)System.getProperties()).put("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byte[] byArray = Hex.decode("FFFFFFFE10FF000000000000");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.isEquals(new BigInteger(Hex.decode("FFFFFFFE10FF000000000000")), aSN1Integer.getValue());
        byArray = Hex.decode("FFFFFFFFFE10FF000000000000");
        try {
            new ASN1Integer(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("malformed integer", illegalArgumentException.getMessage());
        }
    }

    public void testValidEncodingMultiByte() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        byte[] byArray = Hex.decode("10FF");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.checkIntValue(aSN1Integer, 4351);
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byArray = Hex.decode("10FF");
        aSN1Integer = new ASN1Integer(byArray);
        this.checkIntValue(aSN1Integer, 4351);
    }

    public void testValidEncodingSingleByte() throws Exception {
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "false");
        byte[] byArray = Hex.decode("10");
        ASN1Integer aSN1Integer = new ASN1Integer(byArray);
        this.checkIntValue(aSN1Integer, 16);
        System.setProperty("org.bouncycastle.asn1.allow_unsafe_integer", "true");
        byArray = Hex.decode("10");
        aSN1Integer = new ASN1Integer(byArray);
        this.checkIntValue(aSN1Integer, 16);
    }
}

