/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmc;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.crmf.PKIPublicationInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.Arrays;

public class CMCPublicationInfo
extends ASN1Object {
    private final AlgorithmIdentifier hashAlg;
    private final ASN1Sequence certHashes;
    private final PKIPublicationInfo pubInfo;

    private CMCPublicationInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.hashAlg = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.certHashes = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        this.pubInfo = PKIPublicationInfo.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public CMCPublicationInfo(AlgorithmIdentifier algorithmIdentifier, byte[][] byArray, PKIPublicationInfo pKIPublicationInfo) {
        this.hashAlg = algorithmIdentifier;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(byArray.length);
        int n = 0;
        while (n != byArray.length) {
            aSN1EncodableVector.add(new DEROctetString(Arrays.clone(byArray[n])));
            ++n;
        }
        this.certHashes = new DERSequence(aSN1EncodableVector);
        this.pubInfo = pKIPublicationInfo;
    }

    public byte[][] getCertHashes() {
        byte[][] byArray = new byte[this.certHashes.size()][];
        int n = 0;
        while (n != byArray.length) {
            byArray[n] = Arrays.clone(ASN1OctetString.getInstance(this.certHashes.getObjectAt(n)).getOctets());
            ++n;
        }
        return byArray;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public static CMCPublicationInfo getInstance(Object object) {
        if (object instanceof CMCPublicationInfo) {
            return (CMCPublicationInfo)object;
        }
        if (object != null) {
            return new CMCPublicationInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PKIPublicationInfo getPubInfo() {
        return this.pubInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.hashAlg);
        aSN1EncodableVector.add(this.certHashes);
        aSN1EncodableVector.add(this.pubInfo);
        return new DERSequence(aSN1EncodableVector);
    }
}

