/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.bc;

import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.bc.ObjectData;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

public class ObjectDataSequence
extends ASN1Object
implements Iterable {
    private final ASN1Encodable[] dataSequence;

    private ObjectDataSequence(ASN1Sequence aSN1Sequence) {
        this.dataSequence = new ASN1Encodable[aSN1Sequence.size()];
        int n = 0;
        while (n != this.dataSequence.length) {
            this.dataSequence[n] = ObjectData.getInstance(aSN1Sequence.getObjectAt(n));
            ++n;
        }
    }

    public ObjectDataSequence(ObjectData[] objectDataArray) {
        this.dataSequence = new ASN1Encodable[objectDataArray.length];
        System.arraycopy(objectDataArray, 0, this.dataSequence, 0, objectDataArray.length);
    }

    public static ObjectDataSequence getInstance(Object object) {
        if (object instanceof ObjectDataSequence) {
            return (ObjectDataSequence)object;
        }
        if (object != null) {
            return new ObjectDataSequence(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Iterator iterator() {
        return new Arrays.Iterator(this.dataSequence);
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.dataSequence);
    }
}

