/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class DateUtil {
    private static final Map localeCache = new HashMap();
    static Locale EN_Locale = DateUtil.forEN();

    DateUtil() {
    }

    static Date epochAdjust(Date date) throws ParseException {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return date;
        }
        Map map = localeCache;
        synchronized (map) {
            Long l = (Long)localeCache.get(locale);
            if (l == null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
                long l2 = simpleDateFormat.parse("19700101000000GMT+00:00").getTime();
                l = DateUtil.longValueOf(l2);
                localeCache.put(locale, l);
            }
            if (l != 0L) {
                Date date2 = new Date(date.getTime() - l);
                Object var4_8 = null;
                return date2;
            }
            Date date3 = date;
            Object var4_9 = null;
            return date3;
        }
    }

    private static Locale forEN() {
        if ("en".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = 0;
        while (n != localeArray.length) {
            if ("en".equalsIgnoreCase(localeArray[n].getLanguage())) {
                return localeArray[n];
            }
            ++n;
        }
        return Locale.getDefault();
    }

    private static Long longValueOf(long l) {
        return new Long(l);
    }
}

