/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitStringParser;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.util.Arrays;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String,
ASN1BitStringParser {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(class$org$bouncycastle$asn1$ASN1BitString != null ? class$org$bouncycastle$asn1$ASN1BitString : (class$org$bouncycastle$asn1$ASN1BitString = ASN1BitString.class$("org.bouncycastle.asn1.ASN1BitString")), 3){

        ASN1Primitive fromImplicitConstructed(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.toASN1BitString();
        }

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1BitString.createPrimitive(dEROctetString.getOctets());
        }
    };
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final byte[] contents;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1BitString;

    ASN1BitString(byte by, int n) {
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.contents = new byte[]{(byte)n, by};
    }

    ASN1BitString(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("'data' cannot be null");
        }
        if (byArray.length == 0 && n != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (n > 7 || n < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.contents = Arrays.prepend(byArray, (byte)n);
    }

    ASN1BitString(byte[] byArray, boolean bl) {
        if (bl) {
            if (byArray == null) {
                throw new NullPointerException("'contents' cannot be null");
            }
            if (byArray.length < 1) {
                throw new IllegalArgumentException("'contents' cannot be empty");
            }
            int n = byArray[0] & 0xFF;
            if (n > 0) {
                if (byArray.length < 2) {
                    throw new IllegalArgumentException("zero length data with non-zero pad bits");
                }
                if (n > 7) {
                    throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
                }
            }
        }
        this.contents = byArray;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString aSN1BitString = (ASN1BitString)aSN1Primitive;
        byte[] byArray = aSN1BitString.contents;
        byte[] byArray2 = this.contents;
        int n = byArray2.length;
        if (byArray.length != n) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        int n2 = n - 1;
        int n3 = 0;
        while (n3 < n2) {
            if (byArray2[n3] != byArray[n3]) {
                return false;
            }
            ++n3;
        }
        int n4 = byArray2[0] & 0xFF;
        byte by = (byte)(byArray2[n2] & 255 << n4);
        byte by2 = (byte)(byArray[n2] & 255 << n4);
        return by == by2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ASN1BitString createPrimitive(byte[] byArray) {
        int n = byArray.length;
        if (n < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n2 = byArray[0] & 0xFF;
        if (n2 > 0) {
            if (n2 > 7 || n < 2) {
                throw new IllegalArgumentException("invalid pad bits detected");
            }
            byte by = byArray[n - 1];
            if (by != (byte)(by & 255 << n2)) {
                return new DLBitString(byArray, false);
            }
        }
        return new DERBitString(byArray, false);
    }

    public InputStream getBitStream() throws IOException {
        return new ByteArrayInputStream(this.contents, 1, this.contents.length - 1);
    }

    public byte[] getBytes() {
        if (this.contents.length == 1) {
            return ASN1OctetString.EMPTY_OCTETS;
        }
        int n = this.contents[0] & 0xFF;
        byte[] byArray = Arrays.copyOfRange(this.contents, 1, this.contents.length);
        int n2 = byArray.length - 1;
        byArray[n2] = (byte)(byArray[n2] & (byte)(255 << n));
        return byArray;
    }

    protected static byte[] getBytes(int n) {
        if (n == 0) {
            return new byte[0];
        }
        int n2 = 4;
        int n3 = 3;
        while (n3 >= 1) {
            if ((n & 255 << n3 * 8) != 0) break;
            --n2;
            --n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = (byte)(n >> n4 * 8 & 0xFF);
            ++n4;
        }
        return byArray;
    }

    public static ASN1BitString getInstance(Object object) {
        if (object == null || object instanceof ASN1BitString) {
            return (ASN1BitString)object;
        }
        if (object instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1BitString) {
                return (ASN1BitString)aSN1Primitive;
            }
        } else if (object instanceof byte[]) {
            try {
                return (ASN1BitString)TYPE.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct BIT STRING from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1BitString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1BitString)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    public InputStream getOctetStream() throws IOException {
        int n = this.contents[0] & 0xFF;
        if (n != 0) {
            throw new IOException("expected octet-aligned bitstring, but found padBits: " + n);
        }
        return this.getBitStream();
    }

    public byte[] getOctets() {
        if (this.contents[0] != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.copyOfRange(this.contents, 1, this.contents.length);
    }

    public int getPadBits() {
        return this.contents[0] & 0xFF;
    }

    protected static int getPadBits(int n) {
        int n2 = 0;
        int n3 = 3;
        while (n3 >= 0) {
            if (n3 != 0) {
                if (n >> n3 * 8 != 0) {
                    n2 = n >> n3 * 8 & 0xFF;
                    break;
                }
            } else if (n != 0) {
                n2 = n & 0xFF;
                break;
            }
            --n3;
        }
        if (n2 == 0) {
            return 0;
        }
        int n4 = 1;
        while (((n2 <<= 1) & 0xFF) != 0) {
            ++n4;
        }
        return 8 - n4;
    }

    public String getString() {
        byte[] byArray;
        try {
            byArray = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        StringBuffer stringBuffer = new StringBuffer(1 + byArray.length * 2);
        stringBuffer.append('#');
        int n = 0;
        while (n != byArray.length) {
            byte by = byArray[n];
            stringBuffer.append(table[by >>> 4 & 0xF]);
            stringBuffer.append(table[by & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.contents.length < 2) {
            return 1;
        }
        int n = this.contents[0] & 0xFF;
        int n2 = this.contents.length - 1;
        byte by = (byte)(this.contents[n2] & 255 << n);
        int n3 = Arrays.hashCode(this.contents, 0, n2);
        n3 *= 257;
        return n3 ^= by;
    }

    public int intValue() {
        int n = 0;
        int n2 = Math.min(5, this.contents.length - 1);
        int n3 = 1;
        while (n3 < n2) {
            n |= (this.contents[n3] & 0xFF) << 8 * (n3 - 1);
            ++n3;
        }
        if (n2 >= 1 && n2 < 5) {
            int n4 = this.contents[0] & 0xFF;
            byte by = (byte)(this.contents[n2] & 255 << n4);
            n |= (by & 0xFF) << 8 * (n2 - 1);
        }
        return n;
    }

    public ASN1BitStringParser parser() {
        return this;
    }

    ASN1Primitive toDERObject() {
        return new DERBitString(this.contents, false);
    }

    ASN1Primitive toDLObject() {
        return new DLBitString(this.contents, false);
    }

    public String toString() {
        return this.getString();
    }
}

