/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedPrivateKeyInfo {
    private org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo infoObj;
    private AlgorithmParameters algP;

    public EncryptedPrivateKeyInfo(String string, byte[] byArray) throws NullPointerException, IllegalArgumentException, NoSuchAlgorithmException {
        if (string == null || byArray == null) {
            throw new NullPointerException("parameters null");
        }
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(string), null);
        this.infoObj = new org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])byArray.clone());
        this.algP = this.getParameters();
    }

    public EncryptedPrivateKeyInfo(AlgorithmParameters algorithmParameters, byte[] byArray) throws NullPointerException, IllegalArgumentException, NoSuchAlgorithmException {
        if (algorithmParameters == null || byArray == null) {
            throw new NullPointerException("parameters null");
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(algorithmParameters.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(algorithmParameters.getAlgorithm()), aSN1InputStream.readObject());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error in encoding: " + iOException.toString());
        }
        this.infoObj = new org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo(algorithmIdentifier, (byte[])byArray.clone());
        this.algP = this.getParameters();
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws NullPointerException, IOException {
        if (byArray == null) {
            throw new NullPointerException("parameters null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        this.infoObj = org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo.getInstance((ASN1Sequence)aSN1InputStream.readObject());
        try {
            this.algP = this.getParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("can't create parameters: " + noSuchAlgorithmException.toString());
        }
    }

    public String getAlgName() {
        return this.infoObj.getEncryptionAlgorithm().getAlgorithm().getId();
    }

    public AlgorithmParameters getAlgParameters() {
        return this.algP;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
        aSN1OutputStream.writeObject(this.infoObj);
        aSN1OutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncryptedData() {
        return this.infoObj.getEncryptedData();
    }

    public PKCS8EncodedKeySpec getKeySpec(Cipher cipher) throws InvalidKeySpecException {
        try {
            return new PKCS8EncodedKeySpec(cipher.doFinal(this.getEncryptedData()));
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("can't get keySpec: " + exception.toString());
        }
    }

    private AlgorithmParameters getParameters() throws NoSuchAlgorithmException {
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.getAlgName());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
        try {
            aSN1OutputStream.writeObject(this.infoObj.getEncryptionAlgorithm().getParameters());
            aSN1OutputStream.close();
            algorithmParameters.init(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new NoSuchAlgorithmException("unable to parse parameters");
        }
        return algorithmParameters;
    }
}

