/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.utiltest;

import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.util.Integers;

public class IntegersTest
extends TestCase {
    public void testBitCount() {
        Random random = new Random();
        int pos = 0;
        while (pos <= 24) {
            int seed = random.nextInt();
            IntegersTest.implTestBitCountRange(seed, pos, 256);
            ++pos;
        }
    }

    public void testNumberOfLeadingZeros() {
        int i = 0;
        while (i < 31) {
            Assert.assertEquals((int)i, (int)Integers.numberOfLeadingZeros((int)(Integer.MIN_VALUE >>> i)));
            Assert.assertEquals((int)i, (int)Integers.numberOfLeadingZeros((int)(-1 >>> i)));
            ++i;
        }
        Assert.assertEquals((int)31, (int)Integers.numberOfLeadingZeros((int)1));
        Assert.assertEquals((int)32, (int)Integers.numberOfLeadingZeros((int)0));
    }

    public void testNumberOfTrailingZeros() {
        int i = 0;
        while (i < 31) {
            Assert.assertEquals((int)i, (int)Integers.numberOfTrailingZeros((int)(1 << i)));
            Assert.assertEquals((int)i, (int)Integers.numberOfTrailingZeros((int)(-1 << i)));
            ++i;
        }
        Assert.assertEquals((int)31, (int)Integers.numberOfTrailingZeros((int)Integer.MIN_VALUE));
        Assert.assertEquals((int)32, (int)Integers.numberOfTrailingZeros((int)0));
    }

    private static void implTestBitCountRange(int seed, int pos, int count) {
        int i = 0;
        while (i < count) {
            int n = seed + (i << pos);
            Assert.assertEquals((int)IntegersTest.simpleBitCount(n), (int)Integers.bitCount((int)n));
            ++i;
        }
    }

    private static int simpleBitCount(int n) {
        int count = 0;
        int i = 0;
        while (i < 32) {
            count += n >>> i & 1;
            ++i;
        }
        return count;
    }
}

