/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.utiltest;

import java.math.BigInteger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class BigIntegersTest
extends TestCase {
    public String getName() {
        return "BigIntegers";
    }

    public void testAsUnsignedByteArray() {
        BigInteger a = new BigInteger(1, Hex.decode((String)"ff12345678"));
        byte[] a5 = BigIntegers.asUnsignedByteArray((BigInteger)a);
        Assert.assertEquals((int)5, (int)a5.length);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])a5, (byte[])Hex.decode((String)"ff12345678")));
        BigInteger b = new BigInteger(1, Hex.decode((String)"0f12345678"));
        byte[] b5 = BigIntegers.asUnsignedByteArray((BigInteger)b);
        Assert.assertEquals((int)5, (int)b5.length);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])b5, (byte[])Hex.decode((String)"0f12345678")));
    }

    public void testFixedLengthUnsignedByteArray() {
        BigInteger a = new BigInteger(1, Hex.decode((String)"ff12345678"));
        byte[] a5 = BigIntegers.asUnsignedByteArray((int)5, (BigInteger)a);
        Assert.assertEquals((int)5, (int)a5.length);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])a5, (byte[])Hex.decode((String)"ff12345678")));
        byte[] a6 = BigIntegers.asUnsignedByteArray((int)6, (BigInteger)a);
        Assert.assertEquals((int)6, (int)a6.length);
        Assert.assertEquals((int)0, (int)a6[0]);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])a6, (byte[])Hex.decode((String)"00ff12345678")));
        BigInteger b = new BigInteger(1, Hex.decode((String)"0f12345678"));
        byte[] b5 = BigIntegers.asUnsignedByteArray((int)5, (BigInteger)b);
        Assert.assertEquals((int)5, (int)b5.length);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])b5, (byte[])Hex.decode((String)"0f12345678")));
        byte[] b6 = BigIntegers.asUnsignedByteArray((int)6, (BigInteger)b);
        Assert.assertEquals((int)6, (int)b6.length);
        Assert.assertEquals((int)0, (int)b6[0]);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])b6, (byte[])Hex.decode((String)"000f12345678")));
        BigInteger c = new BigInteger(1, Hex.decode((String)"ff123456789a"));
        try {
            byte[] c5 = BigIntegers.asUnsignedByteArray((int)5, (BigInteger)c);
            Assert.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        BigInteger d = new BigInteger(1, Hex.decode((String)"0f123456789a"));
        try {
            byte[] c5 = BigIntegers.asUnsignedByteArray((int)5, (BigInteger)d);
            Assert.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }
}

