/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.util.io.BufferingOutputStream;
import org.bouncycastle.util.test.SimpleTest;

public class BufferingOutputStreamTest
extends SimpleTest {
    public String getName() {
        return "BufferingStreamTest";
    }

    public void performTest() throws Exception {
        SecureRandom random = new SecureRandom();
        int i = 1;
        while (i != 256) {
            byte[] data = new byte[i];
            random.nextBytes(data);
            this.checkStream(data, 16);
            this.checkStream(data, 33);
            this.checkStream(data, 128);
            ++i;
        }
    }

    private void checkStream(byte[] data, int bufsize) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BufferingOutputStream bfOut = new BufferingOutputStream((OutputStream)bOut, bufsize);
        int i = 0;
        while (i != 10) {
            bfOut.write((int)data[0]);
            bfOut.write(data, 1, data.length - 1);
            ++i;
        }
        bfOut.close();
        byte[] output = bOut.toByteArray();
        int i2 = 0;
        while (i2 != 10) {
            int j = 0;
            while (j != data.length) {
                if (output[i2 * data.length + j] != data[j]) {
                    this.fail("data mismatch!");
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new BufferingOutputStreamTest());
    }
}

