/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io.pem.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.test.PrintTestResult;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class AllTests
extends TestCase {
    private static final String blob1 = "-----BEGIN BLOB-----\r\nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==\r\n-----END BLOB-----\r\n";
    private static final String blob2 = "-----BEGIN BLOB-----   \r\nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==\r\n-----END BLOB-----    \r\n";
    private static final String blob3 = "    -----BEGIN BLOB-----\r\nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==\r\n-----END BLOB-----\r\n";
    private static final String blob4 = "-----BEGIN BLOB-----\r\nAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==\r\n    -----END BLOB-----\r\n";
    static /* synthetic */ Class class$org$bouncycastle$util$io$pem$test$AllTests;

    public void testPemLength() throws IOException {
        int i = 1;
        while (i != 60) {
            this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[i]);
            ++i;
        }
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[100]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[101]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[102]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[103]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1000]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1001]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1002]);
        this.lengthTest("CERTIFICATE", Collections.EMPTY_LIST, new byte[1003]);
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>();
        headers.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        headers.add(new PemHeader("DEK-Info", "DES3,0001020304050607"));
        this.lengthTest("RSA PRIVATE KEY", headers, new byte[103]);
    }

    public void testMalformed() throws IOException {
        PemReader rd = new PemReader((Reader)new StringReader("-----BEGIN \n"));
        Assert.assertNull((Object)rd.readPemObject());
    }

    public void testRegularBlob() throws IOException {
        PemReader rd = new PemReader((Reader)new StringReader(blob1));
        PemObject obj = rd.readPemObject();
        Assert.assertEquals((String)"BLOB", (String)obj.getType());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])new byte[64], (byte[])obj.getContent()));
    }

    public void testRegularBlobTrailing() throws IOException {
        PemReader rd = new PemReader((Reader)new StringReader(blob2));
        PemObject obj = rd.readPemObject();
        Assert.assertEquals((String)"BLOB", (String)obj.getType());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])new byte[64], (byte[])obj.getContent()));
    }

    public void testRegularBlobBeginFault() throws IOException {
        PemReader rd = new PemReader((Reader)new StringReader(blob3));
        PemObject obj = rd.readPemObject();
        Assert.assertNull((Object)rd.readPemObject());
    }

    public void testRegularBlobEndFault() throws IOException {
        PemReader rd = new PemReader((Reader)new StringReader(blob4));
        try {
            PemObject obj = rd.readPemObject();
        }
        catch (IOException e) {
            Assert.assertEquals((String)"-----END BLOB----- not found", (String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRegularBlobEndLaxParsing() throws IOException {
        PemObject obj;
        block4: {
            block3: {
                String original = System.setProperty("org.bouncycastle.pemreader.lax", "true");
                PemReader rd = new PemReader((Reader)new StringReader(blob4));
                try {
                    obj = rd.readPemObject();
                    Object var5_4 = null;
                    if (original == null) break block3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (original != null) {
                        System.setProperty("org.bouncycastle.pemreader.lax", original);
                        throw throwable;
                    }
                    System.setProperty("org.bouncycastle.pemreader.lax", "");
                    throw throwable;
                }
                System.setProperty("org.bouncycastle.pemreader.lax", original);
                break block4;
            }
            System.setProperty("org.bouncycastle.pemreader.lax", "");
        }
        Assert.assertEquals((String)"BLOB", (String)obj.getType());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])new byte[64], (byte[])obj.getContent()));
    }

    private void lengthTest(String type, List headers, byte[] data) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PemWriter pWrt = new PemWriter((Writer)new OutputStreamWriter(bOut));
        PemObject pemObj = new PemObject(type, headers, data);
        pWrt.writeObject((PemObjectGenerator)pemObj);
        pWrt.close();
        Assert.assertEquals((int)bOut.toByteArray().length, (int)pWrt.getOutputSize(pemObj));
    }

    public static void main(String[] args) {
        PrintTestResult.printResult(TestRunner.run((Test)AllTests.suite()));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("PEM Tests");
        suite.addTestSuite(class$org$bouncycastle$util$io$pem$test$AllTests == null ? (class$org$bouncycastle$util$io$pem$test$AllTests = AllTests.class$("org.bouncycastle.util.io.pem.test.AllTests")) : class$org$bouncycastle$util$io$pem$test$AllTests);
        return suite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

