/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders.test;

import java.security.SecureRandom;
import org.bouncycastle.util.encoders.UTF8;
import org.bouncycastle.util.test.SimpleTest;

public class UTF8Test
extends SimpleTest {
    private static SecureRandom R = new SecureRandom();

    public String getName() {
        return "UTF8";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new UTF8Test());
    }

    public void performTest() throws Exception {
        int i = 0;
        while (i < 1000) {
            this.testBadPrefix2();
            this.testBadPrefix4();
            this.testBadSuffix_E0();
            this.testBadSuffix_ED();
            this.testBadSuffix_F0();
            this.testBadSuffix_F4();
            this.testIncomplete2_1();
            this.testIncomplete3_1();
            this.testIncomplete3_2();
            this.testIncomplete4_1();
            this.testIncomplete4_2();
            this.testIncomplete4_3();
            this.testLeadingSuffix();
            this.testTruncated2();
            this.testTruncated3();
            this.testTruncated4();
            this.testValid1();
            this.testValid2();
            this.testValid3();
            this.testValid4();
            ++i;
        }
    }

    private void testBadPrefix2() {
        byte[] utf8 = new byte[2];
        char[] utf16 = new char[1];
        int i = 0;
        while (i < 2) {
            utf8[0] = (byte)(0xC0 | i);
            utf8[1] = this.randomSuffix();
            utf16[0] = '\u0000';
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testBadPrefix2", result, -1L);
            ++i;
        }
    }

    private void testBadPrefix4() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        int i = 5;
        while (i < 15) {
            utf8[0] = (byte)(0xF0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf8[3] = this.randomSuffix();
            utf16[0] = '\u0000';
            utf16[1] = '\u0000';
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testBadPrefix4", result, -1L);
            ++i;
        }
    }

    private void testBadSuffix_E0() {
        byte[] utf8 = new byte[3];
        char[] utf16 = new char[1];
        utf8[0] = -32;
        utf8[1] = this.randomSuffix();
        utf8[2] = this.randomSuffix();
        utf16[0] = '\u0000';
        utf8[1] = (byte)(utf8[1] & 0x9F);
        int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
        this.isEquals("testBadSuffix_E0", result, -1L);
    }

    private void testBadSuffix_ED() {
        byte[] utf8 = new byte[3];
        char[] utf16 = new char[1];
        utf8[0] = -19;
        utf8[1] = this.randomSuffix();
        utf8[2] = this.randomSuffix();
        utf16[0] = '\u0000';
        utf8[1] = (byte)(utf8[1] | 0x20);
        int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
        this.isEquals("testBadSuffix_ED", result, -1L);
    }

    private void testBadSuffix_F0() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        utf8[0] = -16;
        utf8[1] = this.randomSuffix();
        utf8[2] = this.randomSuffix();
        utf8[3] = this.randomSuffix();
        utf16[0] = '\u0000';
        utf16[1] = '\u0000';
        utf8[1] = (byte)(utf8[1] & 0x8F);
        int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
        this.isEquals("testBadSuffix_F0", result, -1L);
    }

    private void testBadSuffix_F4() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        utf8[0] = -12;
        utf8[1] = this.randomSuffix();
        utf8[2] = this.randomSuffix();
        utf8[3] = this.randomSuffix();
        utf16[0] = '\u0000';
        utf16[1] = '\u0000';
        utf8[1] = (byte)(utf8[1] | 16 << (R.nextInt() & 1));
        int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
        this.isEquals("testBadSuffix_F4", result, -1L);
    }

    private void testIncomplete2_1() {
        byte[] utf8 = new byte[2];
        char[] utf16 = new char[1];
        int i = 2;
        while (i < 32) {
            utf8[0] = (byte)(0xC0 | i);
            utf8[1] = this.randomPrefix();
            utf16[0] = 65535;
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testIncomplete2_1", result, -1L);
            ++i;
        }
    }

    private void testIncomplete3_1() {
        byte[] utf8 = new byte[3];
        char[] utf16 = new char[1];
        int i = 0;
        while (i < 16) {
            utf8[0] = (byte)(0xE0 | i);
            utf8[1] = this.randomPrefix();
            utf8[2] = this.randomSuffix();
            utf16[0] = 65535;
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testIncomplete3_1", result, -1L);
            ++i;
        }
    }

    private void testIncomplete3_2() {
        byte[] utf8 = new byte[3];
        char[] utf16 = new char[1];
        int i = 0;
        while (i < 16) {
            utf8[0] = (byte)(0xE0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomPrefix();
            utf16[0] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 0x20);
            } else if (i == 13) {
                utf8[1] = (byte)(utf8[1] & 0x9F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testIncomplete3_2", result, -1L);
            ++i;
        }
    }

    private void testIncomplete4_1() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        int i = 0;
        while (i < 5) {
            utf8[0] = (byte)(0xF0 | i);
            utf8[1] = this.randomPrefix();
            utf8[2] = this.randomSuffix();
            utf8[3] = this.randomSuffix();
            utf16[0] = '\u0000';
            utf16[1] = '\u0000';
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testIncomplete4_1", result, -1L);
            ++i;
        }
    }

    private void testIncomplete4_2() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        int i = 0;
        while (i < 5) {
            utf8[0] = (byte)(0xF0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomPrefix();
            utf8[3] = this.randomSuffix();
            utf16[0] = '\u0000';
            utf16[1] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 16 << (R.nextInt() & 1));
            } else if (i == 4) {
                utf8[1] = (byte)(utf8[1] & 0x8F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testIncomplete4_2", result, -1L);
            ++i;
        }
    }

    private void testIncomplete4_3() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        int i = 0;
        while (i < 5) {
            utf8[0] = (byte)(0xF0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf8[3] = this.randomPrefix();
            utf16[0] = '\u0000';
            utf16[1] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 16 << (R.nextInt() & 1));
            } else if (i == 4) {
                utf8[1] = (byte)(utf8[1] & 0x8F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testIncomplete4_3", result, -1L);
            ++i;
        }
    }

    private void testLeadingSuffix() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[4];
        int i = 128;
        while (i < 192) {
            utf8[0] = (byte)i;
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf8[3] = this.randomSuffix();
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testLeadingSuffix", result, -1L);
            ++i;
        }
    }

    private void testTruncated2() {
        byte[] utf8 = new byte[2];
        char[] utf16 = new char[1];
        int i = 2;
        while (i < 32) {
            utf8[0] = (byte)(0xC0 | i);
            utf8[1] = this.randomSuffix();
            utf16[0] = '\u0000';
            int result = UTF8.transcodeToUTF16((byte[])utf8, (int)0, (int)1, (char[])utf16);
            this.isEquals("testTruncated2", result, -1L);
            ++i;
        }
    }

    private void testTruncated3() {
        byte[] utf8 = new byte[3];
        char[] utf16 = new char[1];
        int i = 0;
        while (i < 16) {
            utf8[0] = (byte)(0xE0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf16[0] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 0x20);
            } else if (i == 13) {
                utf8[1] = (byte)(utf8[1] & 0x9F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (int)0, (int)2, (char[])utf16);
            this.isEquals("testTruncated3", result, -1L);
            ++i;
        }
    }

    private void testTruncated4() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        int i = 0;
        while (i < 5) {
            utf8[0] = (byte)(0xF0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf8[3] = this.randomSuffix();
            utf16[0] = '\u0000';
            utf16[1] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 16 << (R.nextInt() & 1));
            } else if (i == 4) {
                utf8[1] = (byte)(utf8[1] & 0x8F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (int)0, (int)3, (char[])utf16);
            this.isEquals("testTruncated4", result, -1L);
            ++i;
        }
    }

    private void testValid1() {
        byte[] utf8 = new byte[1];
        char[] utf16 = new char[1];
        int i = 0;
        while (i < 128) {
            utf8[0] = (byte)i;
            utf16[0] = 65535;
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testValid1.Result", result, 1L);
            this.isEquals("testValid1.Value", utf16[0], i);
            ++i;
        }
    }

    private void testValid2() {
        byte[] utf8 = new byte[2];
        char[] utf16 = new char[1];
        int i = 2;
        while (i < 32) {
            utf8[0] = (byte)(0xC0 | i);
            utf8[1] = this.randomSuffix();
            utf16[0] = '\u0000';
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testValid2.Result", result, 1L);
            this.isEquals("testValid2.Value", utf16[0], i << 6 | utf8[1] & 0x3F);
            ++i;
        }
    }

    private void testValid3() {
        byte[] utf8 = new byte[3];
        char[] utf16 = new char[1];
        int i = 0;
        while (i < 16) {
            utf8[0] = (byte)(0xE0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf16[0] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 0x20);
            } else if (i == 13) {
                utf8[1] = (byte)(utf8[1] & 0x9F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testValid3.Result", result, 1L);
            this.isEquals("testValid3.Value", utf16[0], i << 12 | (utf8[1] & 0x3F) << 6 | utf8[2] & 0x3F);
            ++i;
        }
    }

    private void testValid4() {
        byte[] utf8 = new byte[4];
        char[] utf16 = new char[2];
        int i = 0;
        while (i < 5) {
            utf8[0] = (byte)(0xF0 | i);
            utf8[1] = this.randomSuffix();
            utf8[2] = this.randomSuffix();
            utf8[3] = this.randomSuffix();
            utf16[0] = '\u0000';
            utf16[1] = '\u0000';
            if (i == 0) {
                utf8[1] = (byte)(utf8[1] | 16 << (R.nextInt() & 1));
            } else if (i == 4) {
                utf8[1] = (byte)(utf8[1] & 0x8F);
            }
            int result = UTF8.transcodeToUTF16((byte[])utf8, (char[])utf16);
            this.isEquals("testValid4.Result", result, 2L);
            this.isEquals("testValid4.Value", utf16[0] - 55232 << 10 | utf16[1] - 56320, i << 18 | (utf8[1] & 0x3F) << 12 | (utf8[2] & 0x3F) << 6 | utf8[3] & 0x3F);
            ++i;
        }
    }

    private byte randomInRange(byte lo, byte hi) {
        int a = lo & 0xFF;
        int b = hi & 0xFF;
        int d = b - a;
        return (byte)(lo + (R.nextInt() >>> 1) % d);
    }

    private byte randomPrefix() {
        switch ((R.nextInt() & 3) + 1) {
            case 2: {
                return this.randomInRange((byte)-62, (byte)-32);
            }
            case 3: {
                return this.randomInRange((byte)-32, (byte)-16);
            }
            case 4: {
                return this.randomInRange((byte)-16, (byte)-10);
            }
        }
        return (byte)(R.nextInt() & 0x7F);
    }

    private byte randomSuffix() {
        return (byte)(R.nextInt() >>> 26 | 0x80);
    }
}

