/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders.test;

import java.io.IOException;
import junit.framework.Assert;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.encoders.HexEncoder;
import org.bouncycastle.util.encoders.test.AbstractCoderTest;

public class HexTest
extends AbstractCoderTest {
    private static final String invalid1 = "%O4T";
    private static final String invalid2 = "FZI4";
    private static final String invalid3 = "ae%E";
    private static final String invalid4 = "fO4%";
    private static final String invalid5 = "beefe";
    private static final String invalid6 = "beefs";

    public HexTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.enc = new HexEncoder();
    }

    public void testLength() {
        String r = "616263";
        String v = "abc";
        Assert.assertEquals((int)r.length(), (int)this.enc.getEncodedLength(v.length()));
        Assert.assertEquals((int)v.length(), (int)this.enc.getMaxDecodedLength(r.length()));
    }

    protected char paddingChar() {
        return '\u0000';
    }

    protected boolean isEncodedChar(char c) {
        if ('A' <= c && c <= 'F') {
            return true;
        }
        if ('a' <= c && c <= 'f') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    public void testInvalidInput() throws IOException {
        String[] invalid = new String[]{invalid1, invalid2, invalid3, invalid4, invalid5, invalid6};
        int i = 0;
        while (i != invalid.length) {
            this.invalidTest(invalid[i]);
            this.invalidTest(Strings.toByteArray((String)invalid[i]));
            ++i;
        }
    }

    private void invalidTest(String data) {
        try {
            Hex.decode((String)data);
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"invalid String data parsed");
    }

    private void invalidTest(byte[] data) {
        try {
            Hex.decode((byte[])data);
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"invalid byte data parsed");
    }
}

