/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Assert;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Encoder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.encoders.test.AbstractCoderTest;

public class Base64Test
extends AbstractCoderTest {
    private static final String sample1 = "mO4TyLWG7vjFWdKT8IJcVbZ/jwc=";
    private static final byte[] sample1Bytes = Hex.decode((String)"98ee13c8b586eef8c559d293f0825c55b67f8f07");
    private static final String sample2 = "F4I4p8Vf/mS+Kxvri3FPoMcqmJ1f";
    private static final byte[] sample2Bytes = Hex.decode((String)"178238a7c55ffe64be2b1beb8b714fa0c72a989d5f");
    private static final String sample3 = "UJmEdJYodqHJmd7Rtv6/OP29/jUEFw==";
    private static final byte[] sample3Bytes = Hex.decode((String)"50998474962876a1c999ded1b6febf38fdbdfe350417");
    private static final String invalid1 = "%O4TyLWG7vjFWdKT8IJcVbZ/jwc=";
    private static final String invalid2 = "F%I4p8Vf/mS+Kxvri3FPoMcqmJ1f";
    private static final String invalid3 = "UJ%EdJYodqHJmd7Rtv6/OP29/jUEFw==";
    private static final String invalid4 = "mO4%yLWG7vjFWdKT8IJcVbZ/jwc=";
    private static final String invalid5 = "UJmEdJYodqHJmd7Rtv6/OP29/jUEF%==";
    private static final String invalid6 = "mO4TyLWG7vjFWdKT8IJcVbZ/jw%=";
    private static final String invalid7 = "F4I4p8Vf/mS+Kxvri3FPoMcqmJ1%";
    private static final String invalid8 = "UJmEdJYodqHJmd7Rtv6/OP29/jUE%c==";
    private static final String invalid9 = "mO4TyLWG7vjFWdKT8IJcVbZ/j%c=";
    private static final String invalida = "F4I4p8Vf/mS+Kxvri3FPoMcqmJ%1";
    private static final String invalidb = "UJmEdJYodqHJmd7Rtv6/OP29/jU%Fc==";
    private static final String invalidc = "mO4TyLWG7vjFWdKT8IJcVbZ/%wc=";
    private static final String invalidd = "F4I4p8Vf/mS+Kxvri3FPoMcqm%1c";
    private static final String invalide = "UJmEdJYodqHJmd7Rtv6/OP29/jUEFw=1";
    private static final String invalidf = "DAxFSkJDQSBTYW";
    private static final String invalidg = "M";

    public Base64Test(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.enc = new Base64Encoder();
    }

    public void testSamples() throws IOException {
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])new byte[0], (byte[])Base64.decode((String)"")));
        Assert.assertEquals((int)0, (int)Base64.decode((byte[])new byte[0], (int)0, (int)0, (OutputStream)new ByteArrayOutputStream()));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"1"), (byte[])Base64.decode((String)"MQ==")));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sample1Bytes, (byte[])Base64.decode((String)sample1)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sample1Bytes, (byte[])Base64.decode((byte[])Strings.toByteArray((String)sample1))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sample2Bytes, (byte[])Base64.decode((String)sample2)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sample2Bytes, (byte[])Base64.decode((byte[])Strings.toByteArray((String)sample2))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sample3Bytes, (byte[])Base64.decode((String)sample3)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sample3Bytes, (byte[])Base64.decode((byte[])Strings.toByteArray((String)sample3))));
        Base64Encoder base64Encoder = new Base64Encoder();
        this.lengthCheck((Encoder)base64Encoder, sample1, sample1Bytes);
        this.lengthCheck((Encoder)base64Encoder, sample2, sample2Bytes);
        this.lengthCheck((Encoder)base64Encoder, sample3, sample3Bytes);
    }

    private void lengthCheck(Encoder encoder, String r, byte[] v) throws IOException {
        Assert.assertEquals((int)r.length(), (int)encoder.getEncodedLength(v.length));
        Assert.assertEquals((int)((v.length + 2) / 3 * 3), (int)encoder.getMaxDecodedLength(r.length()));
        Assert.assertEquals((int)r.length(), (int)encoder.encode(v, 0, v.length, (OutputStream)new ByteArrayOutputStream()));
    }

    public void testInvalidInput() throws IOException {
        String[] invalid = new String[]{invalid1, invalid2, invalid3, invalid4, invalid5, invalid6, invalid7, invalid8, invalid9, invalida, invalidb, invalidc, invalidd, invalide, invalidf, invalidg};
        int i = 0;
        while (i != invalid.length) {
            this.invalidTest(invalid[i]);
            this.invalidTest(Strings.toByteArray((String)invalid[i]));
            ++i;
        }
    }

    public void testWithWhitespace() throws Exception {
        String data = "dGVzdHN0cmluZ\r\n               w==";
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"teststring"), (byte[])Base64.decode((String)data)));
        byte[] bData = Strings.toByteArray((String)data);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"teststring"), (byte[])Base64.decode((byte[])bData)));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Base64.decode((byte[])Arrays.concatenate((byte[])new byte[4], (byte[])bData), (int)4, (int)bData.length, (OutputStream)bOut);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"teststring"), (byte[])bOut.toByteArray()));
    }

    private void invalidTest(String data) {
        try {
            Base64.decode((String)data);
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"invalid String data parsed");
    }

    private void invalidTest(byte[] data) {
        try {
            Base64.decode((byte[])data);
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"invalid byte data parsed");
    }

    protected char paddingChar() {
        return '=';
    }

    protected boolean isEncodedChar(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        if (c == '+') {
            return true;
        }
        return c == '/';
    }
}

