/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Assert;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base32;
import org.bouncycastle.util.encoders.Base32Encoder;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Encoder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.encoders.test.AbstractCoderTest;

public class Base32Test
extends AbstractCoderTest {
    String v1 = "";
    String r1 = "";
    String v2 = "f";
    String r2 = "MY======";
    String v3 = "fo";
    String r3 = "MZXQ====";
    String v4 = "foo";
    String r4 = "MZXW6===";
    String v5 = "foob";
    String r5 = "MZXW6YQ=";
    String v6 = "fooba";
    String r6 = "MZXW6YTB";
    String v7 = "foobar";
    String r7 = "MZXW6YTBOI======";
    String v8 = "The quick brown fox jumped over the lazy dog.";
    String r8 = "KRUGKIDROVUWG2ZAMJZG653OEBTG66BANJ2W24DFMQQG65TFOIQHI2DFEBWGC6TZEBSG6ZZO";
    String v9 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    String r9 = "MFRGGZDFMZTWQ2LKNNWG23TPOBYXE43UOV3HO6DZPJAUEQ2EIVDEOSCJJJFUYTKOJ5IFCUSTKRKVMV2YLFNA====";
    byte[] v10 = Hex.decode((String)"FF 62 63 FF 65 66 67 68 69 6a 6b 6c 6d 6e 6f 70 71 72 73 74 75 76 77 FA 79 7a 41 FF 43 44 45 46 47 48 49 4a FF 4c 4d 4e 4f 50 51 52 53 54 55 56 57 58 59 5a");
    String r10 = "75RGH73FMZTWQ2LKNNWG23TPOBYXE43UOV3HP6TZPJA76Q2EIVDEOSCJJL7UYTKOJ5IFCUSTKRKVMV2YLFNA====";
    private static final String invalid1 = "%ZXXOIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY===";
    private static final String invalid2 = "J%XXOIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY===";
    private static final String invalid3 = "JZ%XOIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY====";
    private static final String invalid4 = "JZX%OIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY===";
    private static final String invalid5 = "JZXX%IDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY===";
    private static final String invalid6 = "JZXXO%DJOMQHI2DFEB2GS3LFEBTG64RAMFWGY===";
    private static final String invalid7 = "JZXXOIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY==";
    private static final String invalid8 = "JZXXOIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY==%";
    private static final String invalid9 = "JZXXOIDJOMQHI2DFEB2GS3LFEBTG64RAMFWGY%==";
    private static final String invalida = "JZXXOIDJO=======";
    private static final String invalidb = "JZXXOIDJO======";
    private static final String invalidc = "JZXXOIDJO====";
    private static final String invalidd = "JZXXOIDJO=====";
    private static final String invalide = "JZXXOIDJO===";
    private static final String invalidf = "DAXFSKJDQSBTYW";
    private static final String invalidg = "M";

    public Base32Test(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.enc = new Base32Encoder();
    }

    public void testSamples() throws IOException {
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r1), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v1))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r2), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v2))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r3), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v3))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r4), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v4))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r5), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v5))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r6), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v6))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r7), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v7))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r8), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v8))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r9), (byte[])Base32.encode((byte[])Strings.toByteArray((String)this.v9))));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.r10), (byte[])Base32.encode((byte[])this.v10)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v1), (byte[])Base32.decode((String)this.r1)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v2), (byte[])Base32.decode((String)this.r2)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v3), (byte[])Base32.decode((String)this.r3)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v4), (byte[])Base32.decode((String)this.r4)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v5), (byte[])Base32.decode((String)this.r5)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v6), (byte[])Base32.decode((String)this.r6)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v7), (byte[])Base32.decode((String)this.r7)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v8), (byte[])Base32.decode((String)this.r8)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)this.v9), (byte[])Base32.decode((String)this.r9)));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])this.v10, (byte[])Base32.decode((String)this.r10)));
        Base32Encoder b32Encoder = new Base32Encoder();
        this.lengthCheck((Encoder)b32Encoder, this.r1, this.v1);
        this.lengthCheck((Encoder)b32Encoder, this.r2, this.v2);
        this.lengthCheck((Encoder)b32Encoder, this.r3, this.v3);
        this.lengthCheck((Encoder)b32Encoder, this.r4, this.v4);
        this.lengthCheck((Encoder)b32Encoder, this.r5, this.v5);
        this.lengthCheck((Encoder)b32Encoder, this.r6, this.v6);
        this.lengthCheck((Encoder)b32Encoder, this.r7, this.v7);
        this.lengthCheck((Encoder)b32Encoder, this.r8, this.v8);
        this.lengthCheck((Encoder)b32Encoder, this.r9, this.v9);
    }

    private void lengthCheck(Encoder encoder, String r, String v) {
        Assert.assertEquals((int)r.length(), (int)encoder.getEncodedLength(v.length()));
        Assert.assertEquals((int)((v.length() + 4) / 5 * 5), (int)encoder.getMaxDecodedLength(r.length()));
    }

    public void testInvalidInput() throws IOException {
        String[] invalid = new String[]{invalid1, invalid2, invalid3, invalid4, invalid5, invalid6, invalid7, invalid8, invalid9, invalida, invalidb, invalidc, invalidd, invalide, invalidf, invalidg};
        int i = 0;
        while (i != invalid.length) {
            this.invalidTest(invalid[i]);
            this.invalidTest(Strings.toByteArray((String)invalid[i]));
            ++i;
        }
    }

    public void testWithWhitespace() throws Exception {
        String data = "ORSXG5DTORZG\r\n               S3TH";
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"teststring"), (byte[])Base32.decode((String)data)));
        byte[] bData = Strings.toByteArray((String)data);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"teststring"), (byte[])Base32.decode((byte[])bData)));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Base32.decode((byte[])Arrays.concatenate((byte[])new byte[4], (byte[])bData), (int)4, (int)bData.length, (OutputStream)bOut);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])Strings.toByteArray((String)"teststring"), (byte[])bOut.toByteArray()));
    }

    public void testWithSpecificAlphabet() throws Exception {
        Base32Encoder b32Encoder = new Base32Encoder(Strings.toByteArray((String)"0123456789ABCDEFGHIJKLMNOPQRSTUV"), 61);
        byte[] v1 = Strings.toByteArray((String)"Now is the time for all");
        byte[] r1 = Strings.toByteArray((String)"9PNNE839ECG78Q3541Q6IRB541J6USH0C5M6O===");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(b32Encoder.getEncodedLength(v1.length));
        b32Encoder.encode(v1, 0, v1.length, (OutputStream)bOut);
        Assert.assertEquals((int)((v1.length + 4) / 5 * 5), (int)b32Encoder.getMaxDecodedLength(r1.length));
        Assert.assertEquals((int)bOut.toByteArray().length, (int)b32Encoder.getEncodedLength(v1.length));
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])bOut.toByteArray(), (byte[])r1));
        bOut = new ByteArrayOutputStream(b32Encoder.getMaxDecodedLength(r1.length));
        b32Encoder.decode(r1, 0, r1.length, (OutputStream)bOut);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])bOut.toByteArray(), (byte[])v1));
    }

    private void invalidTest(String data) {
        try {
            Base32.decode((String)data);
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"invalid String data parsed");
    }

    private void invalidTest(byte[] data) {
        try {
            Base32.decode((byte[])data);
        }
        catch (DecoderException e) {
            return;
        }
        Assert.fail((String)"invalid byte data parsed");
    }

    protected char paddingChar() {
        return '=';
    }

    protected boolean isEncodedChar(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".indexOf(c) >= 0;
    }
}

