/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.SavableDigest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.operator.DigestCalculator;

class SHA256DigestCalculator
implements DigestCalculator {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    SHA256DigestCalculator() {
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
    }

    public OutputStream getOutputStream() {
        return this.bOut;
    }

    public byte[] getDigest() {
        byte[] bytes = this.bOut.toByteArray();
        this.bOut.reset();
        SavableDigest sha256 = SHA256Digest.newInstance();
        sha256.update(bytes, 0, bytes.length);
        byte[] digest = new byte[sha256.getDigestSize()];
        sha256.doFinal(digest, 0);
        return digest;
    }
}

