/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.tsp.test.SHA1DigestCalculator;

public class PQCTSPTest
extends TestCase {
    private static final String BC = "BC";

    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void testLMS() throws Exception {
        PublicKey pubKey;
        PrivateKey privKey;
        BouncyCastlePQCProvider pqcProvider = new BouncyCastlePQCProvider();
        Security.addProvider((Provider)pqcProvider);
        try {
            KeyPairGenerator g = KeyPairGenerator.getInstance("LMS", "BCPQC");
            KeyPair p = g.generateKeyPair();
            privKey = p.getPrivate();
            pubKey = p.getPublic();
        }
        catch (Exception e) {
            Assert.fail((String)("error setting up keys - " + e.toString()));
            return;
        }
        ContentSigner sigGen = new JcaContentSignerBuilder("LMS").setProvider((Provider)pqcProvider).build(privKey);
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X500Name("CN=Test"), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name("CN=Test"), pubKey);
        certGen.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping));
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(certGen.build(sigGen));
        ContentSigner signer = new JcaContentSignerBuilder("LMS").setProvider((Provider)pqcProvider).build(privKey);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setContentDigest(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)).build(signer, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SM3, new byte[32], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSignerInfoVerifierBuilder(new JcaDigestCalculatorProviderBuilder().build()).setProvider((Provider)pqcProvider).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }
}

