/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.CMSAttributeTableGenerationException;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.tsp.GenTimeAccuracy;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.tsp.test.SHA1DigestCalculator;
import org.bouncycastle.tsp.test.SHA256DigestCalculator;
import org.bouncycastle.tsp.test.TSPTestUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class NewTSPTest
extends TestCase {
    private static final String BC = "BC";

    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void testGeneral() throws Exception {
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = TSPTestUtil.makeKeyPair();
        X509Certificate signCert = TSPTestUtil.makeCACertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = TSPTestUtil.makeKeyPair();
        X509Certificate origCert = TSPTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        this.basicTest(origKP.getPrivate(), origCert, (Store)certs);
        TimeStampRequest tReq = new TimeStampRequest(Base64.decode((String)"MDcCAQEwLzALBglghkgBZQMEAgEEIJg0h23PsFyxZ6XCSVPrpYxKyJsa31fyjy+dCa8QfujwAQH/"));
        Assert.assertTrue((boolean)tReq.getCertReq());
        this.resolutionTest(origKP.getPrivate(), origCert, (Store)certs, 0, "19700101000009Z");
        this.resolutionTest(origKP.getPrivate(), origCert, (Store)certs, 1, "19700101000009.9Z");
        this.resolutionTest(origKP.getPrivate(), origCert, (Store)certs, 2, "19700101000009.99Z");
        this.resolutionTest(origKP.getPrivate(), origCert, (Store)certs, 3, "19700101000009.999Z");
        this.basicSha256Test(origKP.getPrivate(), origCert, (Store)certs);
        this.basicTestWithTSA(origKP.getPrivate(), origCert, (Store)certs);
        this.overrideAttrsTest(origKP.getPrivate(), origCert, (Store)certs);
        this.responseValidationTest(origKP.getPrivate(), origCert, (Store)certs);
        this.incorrectHashTest(origKP.getPrivate(), origCert, (Store)certs);
        this.badAlgorithmTest(origKP.getPrivate(), origCert, (Store)certs);
        this.timeNotAvailableTest(origKP.getPrivate(), origCert, (Store)certs);
        this.badPolicyTest(origKP.getPrivate(), origCert, (Store)certs);
        this.tokenEncodingTest(origKP.getPrivate(), origCert, (Store)certs);
        this.certReqTest(origKP.getPrivate(), origCert, (Store)certs);
        this.testAccuracyZeroCerts(origKP.getPrivate(), origCert, (Store)certs);
        this.testAccuracyWithCertsAndOrdering(origKP.getPrivate(), origCert, (Store)certs);
        this.testNoNonse(origKP.getPrivate(), origCert, (Store)certs);
        this.extensionTest(origKP.getPrivate(), origCert, (Store)certs);
        this.additionalExtensionTest(origKP.getPrivate(), origCert, (Store)certs);
    }

    public void testCertOrdering() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        String _origDN = "O=Bouncy Castle, C=AU";
        KeyPair _origKP = CMSTestUtil.makeKeyPair();
        X509Certificate _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _origKP, _origDN);
        String _signDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
        KeyPair _signKP = CMSTestUtil.makeKeyPair();
        X509Certificate _signCert = TSPTestUtil.makeCertificate(_signKP, _signDN, _origKP, _origDN);
        KeyPair _signDsaKP = CMSTestUtil.makeDsaKeyPair();
        X509Certificate _signDsaCert = CMSTestUtil.makeCertificate(_signDsaKP, _signDN, _origKP, _origDN);
        certList.add(_origCert);
        certList.add(_signDsaCert);
        certList.add(_signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", _signKP.getPrivate(), _signCert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates((Store)certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse initResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        CMSSignedData sd = initResp.getTimeStampToken().toCMSSignedData();
        certs = sd.getCertificates();
        Iterator it = certs.getMatches(null).iterator();
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        TimeStampResponse dlResp = new TimeStampResponse(initResp.getEncoded("DL"));
        sd = dlResp.getTimeStampToken().toCMSSignedData();
        certs = sd.getCertificates();
        it = certs.getMatches(null).iterator();
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        TimeStampResponse derResp = new TimeStampResponse(initResp.getEncoded());
        sd = derResp.getTimeStampToken().toCMSSignedData();
        certs = sd.getCertificates();
        it = certs.getMatches(null).iterator();
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_origCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signCert), it.next());
        Assert.assertEquals((Object)new JcaX509CertificateHolder(_signDsaCert), it.next());
    }

    private void basicTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }

    public void testSM2withSM3() throws Exception {
        PublicKey pubKey;
        PrivateKey privKey;
        try {
            KeyPairGenerator g = KeyPairGenerator.getInstance("EC", BC);
            g.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("sm2p256v1"));
            KeyPair p = g.generateKeyPair();
            privKey = p.getPrivate();
            pubKey = p.getPublic();
        }
        catch (Exception e) {
            Assert.fail((String)("error setting up keys - " + e.toString()));
            return;
        }
        ContentSigner sigGen = new JcaContentSignerBuilder("SM3withSM2").setProvider(BC).build(privKey);
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(new X500Name("CN=Test"), BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), new X500Name("CN=Test"), pubKey);
        certGen.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_timeStamping));
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate(certGen.build(sigGen));
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SM3withSM2", privKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SM3, new byte[32], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }

    private void resolutionTest(PrivateKey privateKey, X509Certificate cert, Store certs, int resolution, String timeString) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setResolution(resolution);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date(9999L));
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        Assert.assertEquals((String)timeString, (String)tsToken.getTimeStampInfo().toASN1Structure().getGenTime().getTimeString());
        tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date(9000L));
        tsToken = tsResp.getTimeStampToken();
        Assert.assertEquals((String)"19700101000009Z", (String)tsToken.getTimeStampInfo().toASN1Structure().getGenTime().getTimeString());
        if (resolution > 2) {
            tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date(9990L));
            tsToken = tsResp.getTimeStampToken();
            Assert.assertEquals((String)"19700101000009.99Z", (String)tsToken.getTimeStampInfo().toASN1Structure().getGenTime().getTimeString());
        }
        if (resolution > 1) {
            tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date(9900L));
            tsToken = tsResp.getTimeStampToken();
            Assert.assertEquals((String)"19700101000009.9Z", (String)tsToken.getTimeStampInfo().toASN1Structure().getGenTime().getTimeString());
        }
    }

    private void basicSha256Test(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA256withRSA", privateKey, cert), (DigestCalculator)new SHA256DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA256, new byte[32], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        Assert.assertEquals((int)0, (int)tsResp.getStatus());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2));
        SHA256DigestCalculator digCalc = new SHA256DigestCalculator();
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(cert.getEncoded());
        dOut.close();
        byte[] certHash = digCalc.getDigest();
        SigningCertificateV2 sigCertV2 = SigningCertificateV2.getInstance((Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2).getAttributeValues()[0]);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])certHash, (byte[])sigCertV2.getCerts()[0].getCertHash()));
    }

    private void overrideAttrsTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSimpleSignerInfoGeneratorBuilder signerInfoGenBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC);
        IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(new X509CertificateHolder(cert.getEncoded()).getIssuer())), cert.getSerialNumber());
        Object digCalc = new SHA1DigestCalculator();
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(cert.getEncoded());
        dOut.close();
        byte[] certHash = digCalc.getDigest();
        digCalc = new SHA256DigestCalculator();
        dOut = digCalc.getOutputStream();
        dOut.write(cert.getEncoded());
        dOut.close();
        byte[] certHash256 = digCalc.getDigest();
        final ESSCertID essCertid = new ESSCertID(certHash, issuerSerial);
        final ESSCertIDv2 essCertidV2 = new ESSCertIDv2(certHash256, issuerSerial);
        signerInfoGenBuilder.setSignedAttributeGenerator(new CMSAttributeTableGenerator(){

            public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                DefaultSignedAttributeTableGenerator attrGen = new DefaultSignedAttributeTableGenerator();
                AttributeTable table = attrGen.getAttributes(parameters);
                table = table.add(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Encodable)new SigningCertificate(essCertid));
                table = table.add(PKCSObjectIdentifiers.id_aa_signingCertificateV2, (ASN1Encodable)new SigningCertificateV2(new ESSCertIDv2[]{essCertidV2}));
                return table;
            }
        });
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(signerInfoGenBuilder.build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
        Assert.assertNotNull((String)"no signingCertificateV2 attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2));
        SigningCertificate sigCert = SigningCertificate.getInstance((Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate).getAttributeValues()[0]);
        Assert.assertEquals((Object)new X509CertificateHolder(cert.getEncoded()).getIssuer(), (Object)sigCert.getCerts()[0].getIssuerSerial().getIssuer().getNames()[0].getName());
        Assert.assertEquals((Object)cert.getSerialNumber(), (Object)sigCert.getCerts()[0].getIssuerSerial().getSerial().getValue());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])certHash, (byte[])sigCert.getCerts()[0].getCertHash()));
        SigningCertificateV2 sigCertV2 = SigningCertificateV2.getInstance((Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2).getAttributeValues()[0]);
        Assert.assertEquals((Object)new X509CertificateHolder(cert.getEncoded()).getIssuer(), (Object)sigCertV2.getCerts()[0].getIssuerSerial().getIssuer().getNames()[0].getName());
        Assert.assertEquals((Object)cert.getSerialNumber(), (Object)sigCertV2.getCerts()[0].getIssuerSerial().getSerial().getValue());
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])certHash256, (byte[])sigCertV2.getCerts()[0].getCertHash()));
    }

    private void basicTestWithTSA(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setTSA(new GeneralName(new X500Name("CN=Test")));
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }

    private void additionalExtensionTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setTSA(new GeneralName(new X500Name("CN=Test")));
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.auditIdentity, false, (ASN1Encodable)new DERUTF8String("Test"));
        TimeStampResponse tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date(), "Okay", extGen.generate());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
        Extensions ext = tsToken.getTimeStampInfo().getExtensions();
        Assert.assertEquals((int)1, (int)ext.getExtensionOIDs().length);
        Assert.assertEquals((Object)new Extension(Extension.auditIdentity, false, new DERUTF8String("Test").getEncoded()), (Object)ext.getExtension(Extension.auditIdentity));
    }

    private void responseValidationTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        try {
            request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(101L));
            tsResp.validate(request);
            Assert.fail((String)"response validation failed on invalid nonce.");
        }
        catch (TSPValidationException e) {
            // empty catch block
        }
        try {
            request = reqGen.generate(TSPAlgorithms.SHA1, new byte[22], BigInteger.valueOf(100L));
            tsResp.validate(request);
            Assert.fail((String)"response validation failed on wrong digest.");
        }
        catch (TSPValidationException e) {
            // empty catch block
        }
        try {
            request = reqGen.generate(TSPAlgorithms.MD5, new byte[20], BigInteger.valueOf(100L));
            tsResp.validate(request);
            Assert.fail((String)"response validation failed on wrong digest.");
        }
        catch (TSPValidationException e) {
            // empty catch block
        }
    }

    private void incorrectHashTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[16]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            Assert.fail((String)"incorrectHash - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            Assert.fail((String)"incorrectHash - failInfo set to null.");
        }
        if (failInfo.intValue() != 4) {
            Assert.fail((String)"incorrectHash - wrong failure info returned.");
        }
    }

    private void badAlgorithmTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        JcaSimpleSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(new ASN1ObjectIdentifier("1.2.3.4.5"), new byte[20]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            Assert.fail((String)"badAlgorithm - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            Assert.fail((String)"badAlgorithm - failInfo set to null.");
        }
        if (failInfo.intValue() != 128) {
            Assert.fail((String)"badAlgorithm - wrong failure info returned.");
        }
    }

    private void timeNotAvailableTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        TimeStampResponse tsResp;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(new ASN1ObjectIdentifier("1.2.3.4.5"), new byte[20]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        try {
            tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), null);
        }
        catch (TSPException e) {
            tsResp = tsRespGen.generateRejectedResponse((Exception)((Object)e));
        }
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            Assert.fail((String)"timeNotAvailable - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            Assert.fail((String)"timeNotAvailable - failInfo set to null.");
        }
        if (failInfo.intValue() != 512) {
            Assert.fail((String)"timeNotAvailable - wrong failure info returned.");
        }
    }

    private void badPolicyTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        PKIFailureInfo failInfo;
        TimeStampResponse tsResp;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setReqPolicy(new ASN1ObjectIdentifier("1.1"));
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20]);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED, new HashSet());
        try {
            tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        }
        catch (TSPException e) {
            tsResp = tsRespGen.generateRejectedResponse((Exception)((Object)e));
        }
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        if (tsToken != null) {
            Assert.fail((String)"badPolicy - token not null.");
        }
        if ((failInfo = tsResp.getFailInfo()) == null) {
            Assert.fail((String)"badPolicy - failInfo set to null.");
        }
        if (failInfo.intValue() != 256) {
            Assert.fail((String)"badPolicy - wrong failure info returned.");
        }
    }

    private void certReqTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(false);
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        Assert.assertNull((Object)tsToken.getTimeStampInfo().getGenTimeAccuracy());
        Assert.assertEquals((String)"1.2", (String)tsToken.getTimeStampInfo().getPolicy().getId());
        try {
            tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        }
        catch (TSPValidationException e) {
            Assert.fail((String)"certReq(false) verification of token failed.");
        }
        Store respCerts = tsToken.getCertificates();
        Collection certsColl = respCerts.getMatches(null);
        if (!certsColl.isEmpty()) {
            Assert.fail((String)"certReq(false) found certificates in response.");
        }
    }

    private void tokenEncodingTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2.3.4.5.6"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampResponse tsResponse = new TimeStampResponse(tsResp.getEncoded());
        if (!Arrays.areEqual((byte[])tsResponse.getEncoded(), (byte[])tsResp.getEncoded()) || !Arrays.areEqual((byte[])tsResponse.getTimeStampToken().getEncoded(), (byte[])tsResp.getTimeStampToken().getEncoded())) {
            Assert.fail();
        }
    }

    private void testAccuracyZeroCerts(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setAccuracySeconds(1);
        tsTokenGen.setAccuracyMillis(2);
        tsTokenGen.setAccuracyMicros(3);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        TimeStampTokenInfo tstInfo = tsToken.getTimeStampInfo();
        GenTimeAccuracy accuracy = tstInfo.getGenTimeAccuracy();
        Assert.assertEquals((int)1, (int)accuracy.getSeconds());
        Assert.assertEquals((int)2, (int)accuracy.getMillis());
        Assert.assertEquals((int)3, (int)accuracy.getMicros());
        Assert.assertEquals((Object)new BigInteger("23"), (Object)tstInfo.getSerialNumber());
        Assert.assertEquals((String)"1.2", (String)tstInfo.getPolicy().getId());
        Store store = tsToken.getCertificates();
        Collection certificates = store.getMatches(null);
        Assert.assertEquals((int)0, (int)certificates.size());
    }

    private void testAccuracyWithCertsAndOrdering(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampResponse tsResp;
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2.3"));
        tsTokenGen.addCertificates(certs);
        tsTokenGen.setAccuracySeconds(3);
        tsTokenGen.setAccuracyMillis(1);
        tsTokenGen.setAccuracyMicros(2);
        tsTokenGen.setOrdering(true);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        Assert.assertTrue((boolean)request.getCertReq());
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        try {
            tsResp = tsRespGen.generateGrantedResponse(request, new BigInteger("23"), new Date());
        }
        catch (TSPException e) {
            tsResp = tsRespGen.generateRejectedResponse((Exception)((Object)e));
        }
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        TimeStampTokenInfo tstInfo = tsToken.getTimeStampInfo();
        GenTimeAccuracy accuracy = tstInfo.getGenTimeAccuracy();
        Assert.assertEquals((int)3, (int)accuracy.getSeconds());
        Assert.assertEquals((int)1, (int)accuracy.getMillis());
        Assert.assertEquals((int)2, (int)accuracy.getMicros());
        Assert.assertEquals((Object)new BigInteger("23"), (Object)tstInfo.getSerialNumber());
        Assert.assertEquals((String)"1.2.3", (String)tstInfo.getPolicy().getId());
        Assert.assertEquals((boolean)true, (boolean)tstInfo.isOrdered());
        Assert.assertEquals((Object)tstInfo.getNonce(), (Object)BigInteger.valueOf(100L));
        Store store = tsToken.getCertificates();
        Collection certificates = store.getMatches(null);
        Assert.assertEquals((int)2, (int)certificates.size());
    }

    private void testNoNonse(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        JcaSignerInfoGeneratorBuilder infoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build());
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(infoGeneratorBuilder.build(new JcaContentSignerBuilder("MD5withRSA").setProvider(BC).build(privateKey), cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2.3"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20]);
        HashSet<ASN1ObjectIdentifier> algorithms = new HashSet<ASN1ObjectIdentifier>();
        algorithms.add(TSPAlgorithms.SHA1);
        request.validate(algorithms, new HashSet(), new HashSet());
        Assert.assertFalse((boolean)request.getCertReq());
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("24"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        tsResp.validate(request);
        TimeStampTokenInfo tstInfo = tsToken.getTimeStampInfo();
        GenTimeAccuracy accuracy = tstInfo.getGenTimeAccuracy();
        Assert.assertNull((Object)accuracy);
        Assert.assertEquals((Object)new BigInteger("24"), (Object)tstInfo.getSerialNumber());
        Assert.assertEquals((String)"1.2.3", (String)tstInfo.getPolicy().getId());
        Assert.assertEquals((boolean)false, (boolean)tstInfo.isOrdered());
        Assert.assertNull((Object)tstInfo.getNonce());
        Store store = tsToken.getCertificates();
        Collection certificates = store.getMatches(null);
        Assert.assertEquals((int)0, (int)certificates.size());
    }

    private void extensionTest(PrivateKey privateKey, X509Certificate cert, Store certs) throws Exception {
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().build("SHA1withRSA", privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates(certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setReqPolicy(Extension.noRevAvail);
        reqGen.addExtension(Extension.biometricInfo, true, (ASN1Encodable)new DEROctetString(new byte[20]));
        TimeStampRequest request = reqGen.generate(TSPAlgorithms.SHA1, new byte[20], BigInteger.valueOf(100L));
        try {
            request.validate(new HashSet(), new HashSet(), new HashSet());
            Assert.fail((String)"no exception");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request contains unknown algorithm");
        }
        HashSet<ASN1ObjectIdentifier> algorithms = new HashSet<ASN1ObjectIdentifier>();
        algorithms.add(TSPAlgorithms.SHA1);
        try {
            request.validate(algorithms, new HashSet(), new HashSet());
            Assert.fail((String)"no exception");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request contains unknown policy");
        }
        HashSet<ASN1ObjectIdentifier> policies = new HashSet<ASN1ObjectIdentifier>();
        policies.add(Extension.noRevAvail);
        try {
            request.validate(algorithms, policies, new HashSet());
            Assert.fail((String)"no exception");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"request contains unknown extension");
        }
        HashSet<ASN1ObjectIdentifier> extensions = new HashSet<ASN1ObjectIdentifier>();
        extensions.add(Extension.biometricInfo);
        request.validate(algorithms, policies, extensions);
        request.validate(algorithms, null, extensions);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        TimeStampToken tsToken = tsResp.getTimeStampToken();
        tsToken.validate(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert));
        AttributeTable table = tsToken.getSignedAttributes();
        Assert.assertNotNull((String)"no signingCertificate attribute found", (Object)table.get(PKCSObjectIdentifiers.id_aa_signingCertificate));
    }
}

