/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.tsp.Accuracy;
import org.bouncycastle.tsp.GenTimeAccuracy;

public class GenTimeAccuracyUnitTest
extends TestCase {
    private static final ASN1Integer ZERO_VALUE = new ASN1Integer(0L);
    private static final ASN1Integer ONE_VALUE = new ASN1Integer(1L);
    private static final ASN1Integer TWO_VALUE = new ASN1Integer(2L);
    private static final ASN1Integer THREE_VALUE = new ASN1Integer(3L);

    public void testOneTwoThree() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(ONE_VALUE, TWO_VALUE, THREE_VALUE));
        this.checkValues(accuracy, ONE_VALUE, TWO_VALUE, THREE_VALUE);
        this.checkToString(accuracy, "1.002003");
    }

    public void testThreeTwoOne() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(THREE_VALUE, TWO_VALUE, ONE_VALUE));
        this.checkValues(accuracy, THREE_VALUE, TWO_VALUE, ONE_VALUE);
        this.checkToString(accuracy, "3.002001");
    }

    public void testTwoThreeTwo() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(TWO_VALUE, THREE_VALUE, TWO_VALUE));
        this.checkValues(accuracy, TWO_VALUE, THREE_VALUE, TWO_VALUE);
        this.checkToString(accuracy, "2.003002");
    }

    public void testZeroTwoThree() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(ZERO_VALUE, TWO_VALUE, THREE_VALUE));
        this.checkValues(accuracy, ZERO_VALUE, TWO_VALUE, THREE_VALUE);
        this.checkToString(accuracy, "0.002003");
    }

    public void testThreeTwoNull() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(THREE_VALUE, TWO_VALUE, null));
        this.checkValues(accuracy, THREE_VALUE, TWO_VALUE, ZERO_VALUE);
        this.checkToString(accuracy, "3.002000");
    }

    public void testOneNullOne() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(ONE_VALUE, null, ONE_VALUE));
        this.checkValues(accuracy, ONE_VALUE, ZERO_VALUE, ONE_VALUE);
        this.checkToString(accuracy, "1.000001");
    }

    public void testZeroNullNull() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(ZERO_VALUE, null, null));
        this.checkValues(accuracy, ZERO_VALUE, ZERO_VALUE, ZERO_VALUE);
        this.checkToString(accuracy, "0.000000");
    }

    public void testNullNullNull() {
        GenTimeAccuracy accuracy = new GenTimeAccuracy(new Accuracy(null, null, null));
        this.checkValues(accuracy, ZERO_VALUE, ZERO_VALUE, ZERO_VALUE);
        this.checkToString(accuracy, "0.000000");
    }

    private void checkValues(GenTimeAccuracy accuracy, ASN1Integer secs, ASN1Integer millis, ASN1Integer micros) {
        Assert.assertEquals((int)secs.intValueExact(), (int)accuracy.getSeconds());
        Assert.assertEquals((int)millis.intValueExact(), (int)accuracy.getMillis());
        Assert.assertEquals((int)micros.intValueExact(), (int)accuracy.getMicros());
    }

    private void checkToString(GenTimeAccuracy accuracy, String expected) {
        Assert.assertEquals((String)expected, (String)accuracy.toString());
    }
}

