/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.cms.CMSTimeStampedDataParser;
import org.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataParserTest
extends TestCase {
    CMSTimeStampedDataParser cmsTimeStampedData = null;
    String fileInput = "FileDaFirmare.txt.tsd.der";
    private byte[] baseData;

    /*
     * WARNING - void declaration
     */
    protected void setUp() throws Exception {
        int ch;
        ByteArrayOutputStream origStream = new ByteArrayOutputStream();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.fileInput);
        while ((ch = in.read()) >= 0) {
            void var3_3;
            origStream.write((int)var3_3);
        }
        origStream.close();
        this.baseData = origStream.toByteArray();
        this.cmsTimeStampedData = new CMSTimeStampedDataParser(this.baseData);
    }

    protected void tearDown() throws Exception {
        this.cmsTimeStampedData = null;
    }

    public void testGetTimeStampTokens() throws Exception {
        TimeStampToken[] tokens = this.cmsTimeStampedData.getTimeStampTokens();
        Assert.assertEquals((int)3, (int)tokens.length);
    }

    public void testValidateAllTokens() throws Exception {
        BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)this.cmsTimeStampedData.getContent(), (OutputStream)bOut);
        DigestCalculator imprintCalculator = this.cmsTimeStampedData.getMessageImprintDigestCalculator((DigestCalculatorProvider)digestCalculatorProvider);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(bOut.toByteArray()), (OutputStream)imprintCalculator.getOutputStream());
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = this.cmsTimeStampedData.getTimeStampTokens();
        int i = 0;
        while (i < tokens.length) {
            this.cmsTimeStampedData.validate((DigestCalculatorProvider)digestCalculatorProvider, digest, tokens[i]);
            ++i;
        }
    }

    public void testValidate() throws Exception {
        BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)this.cmsTimeStampedData.getContent(), (OutputStream)bOut);
        DigestCalculator imprintCalculator = this.cmsTimeStampedData.getMessageImprintDigestCalculator((DigestCalculatorProvider)digestCalculatorProvider);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(bOut.toByteArray()), (OutputStream)imprintCalculator.getOutputStream());
        this.cmsTimeStampedData.validate((DigestCalculatorProvider)digestCalculatorProvider, imprintCalculator.getDigest());
    }
}

