/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampResponseGenerator;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.tsp.cms.CMSTimeStampedData;
import org.bouncycastle.tsp.cms.CMSTimeStampedDataGenerator;
import org.bouncycastle.tsp.cms.CMSTimeStampedDataParser;
import org.bouncycastle.tsp.test.SHA1DigestCalculator;
import org.bouncycastle.tsp.test.TSPTestUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataGeneratorTest
extends TestCase {
    BouncyCastleProvider bouncyCastleProvider;
    CMSTimeStampedDataGenerator cmsTimeStampedDataGenerator = null;
    String fileInput = "FileDaFirmare.data";
    byte[] baseData;

    /*
     * WARNING - void declaration
     */
    protected void setUp() throws Exception {
        int ch;
        this.bouncyCastleProvider = new BouncyCastleProvider();
        if (Security.getProvider(this.bouncyCastleProvider.getName()) == null) {
            Security.addProvider((Provider)this.bouncyCastleProvider);
        }
        this.cmsTimeStampedDataGenerator = new CMSTimeStampedDataGenerator();
        ByteArrayOutputStream origStream = new ByteArrayOutputStream();
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(this.fileInput);
        while ((ch = in.read()) >= 0) {
            void var3_3;
            origStream.write((int)var3_3);
        }
        origStream.close();
        this.baseData = origStream.toByteArray();
    }

    protected void tearDown() throws Exception {
        this.cmsTimeStampedDataGenerator = null;
        Security.removeProvider(this.bouncyCastleProvider.getName());
    }

    public void testGenerate() throws Exception {
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        ASN1ObjectIdentifier algOID = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1");
        DigestCalculator hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algOID));
        this.cmsTimeStampedDataGenerator.initialiseMessageImprintDigestCalculator(hashCalculator);
        hashCalculator.getOutputStream().write(this.baseData);
        hashCalculator.getOutputStream().close();
        TimeStampToken timeStampToken = this.createTimeStampToken(hashCalculator.getDigest(), NISTObjectIdentifiers.id_sha256);
        CMSTimeStampedData cmsTimeStampedData = this.cmsTimeStampedDataGenerator.generate(timeStampToken, this.baseData);
        int i = 0;
        while (i < 3) {
            byte[] newRequestData = cmsTimeStampedData.calculateNextHash(hashCalculator);
            TimeStampToken newTimeStampToken = this.createTimeStampToken(newRequestData, NISTObjectIdentifiers.id_sha256);
            cmsTimeStampedData = cmsTimeStampedData.addTimeStamp(newTimeStampToken);
            ++i;
        }
        byte[] timeStampedData = cmsTimeStampedData.getEncoded();
        BcDigestCalculatorProvider newCalculatorProvider = new BcDigestCalculatorProvider();
        DigestCalculator imprintCalculator = cmsTimeStampedData.getMessageImprintDigestCalculator((DigestCalculatorProvider)newCalculatorProvider);
        CMSTimeStampedData newCMSTimeStampedData = new CMSTimeStampedData(timeStampedData);
        byte[] newContent = newCMSTimeStampedData.getContent();
        Assert.assertEquals((String)"Content expected and verified are different", (boolean)true, (boolean)Arrays.areEqual((byte[])newContent, (byte[])this.baseData));
        imprintCalculator.getOutputStream().write(newContent);
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = cmsTimeStampedData.getTimeStampTokens();
        Assert.assertEquals((String)"TimeStampToken expected and verified are different", (int)4, (int)tokens.length);
        int i2 = 0;
        while (i2 < tokens.length) {
            cmsTimeStampedData.validate((DigestCalculatorProvider)newCalculatorProvider, digest, tokens[i2]);
            ++i2;
        }
    }

    public void testGenerateWithMetadata() throws Exception {
        this.cmsTimeStampedDataGenerator.setMetaData(true, this.fileInput, "TXT");
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        ASN1ObjectIdentifier algOID = new ASN1ObjectIdentifier("2.16.840.1.101.3.4.2.1");
        DigestCalculator hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algOID));
        this.cmsTimeStampedDataGenerator.initialiseMessageImprintDigestCalculator(hashCalculator);
        hashCalculator.getOutputStream().write(this.baseData);
        hashCalculator.getOutputStream().close();
        TimeStampToken timeStampToken = this.createTimeStampToken(hashCalculator.getDigest(), NISTObjectIdentifiers.id_sha256);
        CMSTimeStampedData cmsTimeStampedData = this.cmsTimeStampedDataGenerator.generate(timeStampToken, this.baseData);
        int i = 0;
        while (i <= 3) {
            byte[] newRequestData = cmsTimeStampedData.calculateNextHash(hashCalculator);
            TimeStampToken newTimeStampToken = this.createTimeStampToken(newRequestData, NISTObjectIdentifiers.id_sha256);
            cmsTimeStampedData = cmsTimeStampedData.addTimeStamp(newTimeStampToken);
            ++i;
        }
        byte[] timeStampedData = cmsTimeStampedData.getEncoded();
        this.metadataCheck(timeStampedData);
        this.metadataParserCheck(timeStampedData);
    }

    public void testGenerateWithMetadataAndDifferentAlgorithmIdentifier() throws Exception {
        this.cmsTimeStampedDataGenerator.setMetaData(true, this.fileInput, "TXT");
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        ASN1ObjectIdentifier algIdentifier = NISTObjectIdentifiers.id_sha224;
        DigestCalculator hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algIdentifier));
        this.cmsTimeStampedDataGenerator.initialiseMessageImprintDigestCalculator(hashCalculator);
        hashCalculator.getOutputStream().write(this.baseData);
        hashCalculator.getOutputStream().close();
        byte[] requestData = hashCalculator.getDigest();
        TimeStampToken timeStampToken = this.createTimeStampToken(requestData, algIdentifier);
        CMSTimeStampedData cmsTimeStampedData = this.cmsTimeStampedDataGenerator.generate(timeStampToken, this.baseData);
        int i = 0;
        while (i <= 3) {
            switch (i) {
                case 0: {
                    algIdentifier = NISTObjectIdentifiers.id_sha224;
                    break;
                }
                case 1: {
                    algIdentifier = NISTObjectIdentifiers.id_sha256;
                    break;
                }
                case 2: {
                    algIdentifier = NISTObjectIdentifiers.id_sha384;
                    break;
                }
                case 3: {
                    algIdentifier = NISTObjectIdentifiers.id_sha512;
                }
            }
            hashCalculator = calculatorProvider.get(new AlgorithmIdentifier(algIdentifier));
            byte[] newRequestData = cmsTimeStampedData.calculateNextHash(hashCalculator);
            TimeStampToken newTimeStampToken = this.createTimeStampToken(newRequestData, algIdentifier);
            cmsTimeStampedData = cmsTimeStampedData.addTimeStamp(newTimeStampToken);
            ++i;
        }
        byte[] timeStampedData = cmsTimeStampedData.getEncoded();
        this.metadataCheck(timeStampedData);
        this.metadataParserCheck(timeStampedData);
    }

    private void metadataCheck(byte[] timeStampedData) throws Exception {
        CMSTimeStampedData cmsTspData = new CMSTimeStampedData(timeStampedData);
        BcDigestCalculatorProvider newCalculatorProvider = new BcDigestCalculatorProvider();
        DigestCalculator imprintCalculator = cmsTspData.getMessageImprintDigestCalculator((DigestCalculatorProvider)newCalculatorProvider);
        byte[] newContent = cmsTspData.getContent();
        Assert.assertEquals((String)"Content expected and verified are different", (boolean)true, (boolean)Arrays.areEqual((byte[])newContent, (byte[])this.baseData));
        imprintCalculator.getOutputStream().write(newContent);
        Assert.assertEquals((String)this.fileInput, (String)cmsTspData.getFileName());
        Assert.assertEquals((String)"TXT", (String)cmsTspData.getMediaType());
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = cmsTspData.getTimeStampTokens();
        Assert.assertEquals((String)"TimeStampToken expected and verified are different", (int)5, (int)tokens.length);
        int i = 0;
        while (i < tokens.length) {
            cmsTspData.validate((DigestCalculatorProvider)newCalculatorProvider, digest, tokens[i]);
            ++i;
        }
    }

    private void metadataParserCheck(byte[] timeStampedData) throws Exception {
        CMSTimeStampedDataParser cmsTspData = new CMSTimeStampedDataParser(timeStampedData);
        BcDigestCalculatorProvider newCalculatorProvider = new BcDigestCalculatorProvider();
        InputStream input = cmsTspData.getContent();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)input, (OutputStream)bOut);
        Assert.assertEquals((String)"Content expected and verified are different", (boolean)true, (boolean)Arrays.areEqual((byte[])bOut.toByteArray(), (byte[])this.baseData));
        DigestCalculator imprintCalculator = cmsTspData.getMessageImprintDigestCalculator((DigestCalculatorProvider)newCalculatorProvider);
        Streams.pipeAll((InputStream)new ByteArrayInputStream(bOut.toByteArray()), (OutputStream)imprintCalculator.getOutputStream());
        Assert.assertEquals((String)this.fileInput, (String)cmsTspData.getFileName());
        Assert.assertEquals((String)"TXT", (String)cmsTspData.getMediaType());
        byte[] digest = imprintCalculator.getDigest();
        TimeStampToken[] tokens = cmsTspData.getTimeStampTokens();
        Assert.assertEquals((String)"TimeStampToken expected and verified are different", (int)5, (int)tokens.length);
        int i = 0;
        while (i < tokens.length) {
            cmsTspData.validate((DigestCalculatorProvider)newCalculatorProvider, digest, tokens[i]);
            ++i;
        }
    }

    private TimeStampToken createTimeStampToken(byte[] hash, ASN1ObjectIdentifier hashAlg) throws Exception {
        String algorithmName = null;
        if (hashAlg.equals((ASN1Primitive)NISTObjectIdentifiers.id_sha224)) {
            algorithmName = "SHA224withRSA";
        } else if (hashAlg.equals((ASN1Primitive)NISTObjectIdentifiers.id_sha256)) {
            algorithmName = "SHA256withRSA";
        } else if (hashAlg.equals((ASN1Primitive)NISTObjectIdentifiers.id_sha384)) {
            algorithmName = "SHA384withRSA";
        } else if (hashAlg.equals((ASN1Primitive)NISTObjectIdentifiers.id_sha512)) {
            algorithmName = "SHA512withRSA";
        }
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = TSPTestUtil.makeKeyPair();
        X509Certificate signCert = TSPTestUtil.makeCACertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = TSPTestUtil.makeKeyPair();
        X509Certificate cert = TSPTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        PrivateKey privateKey = origKP.getPrivate();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(cert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        TimeStampTokenGenerator tsTokenGen = new TimeStampTokenGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").build(algorithmName, privateKey, cert), (DigestCalculator)new SHA1DigestCalculator(), new ASN1ObjectIdentifier("1.2"));
        tsTokenGen.addCertificates((Store)certs);
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        TimeStampRequest request = reqGen.generate(hashAlg, hash);
        TimeStampResponseGenerator tsRespGen = new TimeStampResponseGenerator(tsTokenGen, TSPAlgorithms.ALLOWED);
        TimeStampResponse tsResp = tsRespGen.generate(request, new BigInteger("23"), new Date());
        tsResp = new TimeStampResponse(tsResp.getEncoded());
        return tsResp.getTimeStampToken();
    }
}

