/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyPairGenerator;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class SNTRUPrimeTest
extends TestCase {
    private static final String resourcePath = "pqc/crypto/ntruprime/sntrup/";

    /*
     * WARNING - void declaration
     */
    public void testKEM() throws Exception {
        SNTRUPrimeParameters[] paramList = new SNTRUPrimeParameters[]{SNTRUPrimeParameters.sntrup653, SNTRUPrimeParameters.sntrup761, SNTRUPrimeParameters.sntrup857, SNTRUPrimeParameters.sntrup953, SNTRUPrimeParameters.sntrup1013, SNTRUPrimeParameters.sntrup1277};
        TestSampler sampler = new TestSampler();
        int i = 0;
        while (i != paramList.length) {
            String line;
            SNTRUPrimeParameters paramSpec = paramList[i];
            InputStream resource = TestResourceFinder.findTestResource(resourcePath, Strings.toLowerCase((String)paramSpec.getName()) + ".rsp");
            BufferedReader resourceReader = new BufferedReader(new InputStreamReader(resource));
            while ((line = resourceReader.readLine()) != null) {
                void var7_7;
                if (!var7_7.startsWith("count")) continue;
                int a = var7_7.indexOf("=");
                int count = Integer.parseInt(var7_7.substring(a + 1).trim());
                line = resourceReader.readLine();
                a = line.indexOf("=");
                byte[] seed = Hex.decode((String)line.substring(a + 1).trim());
                line = resourceReader.readLine();
                a = line.indexOf("=");
                byte[] pk = Hex.decode((String)line.substring(a + 1).trim());
                line = resourceReader.readLine();
                a = line.indexOf("=");
                byte[] sk = Hex.decode((String)line.substring(a + 1).trim());
                line = resourceReader.readLine();
                a = line.indexOf("=");
                byte[] ct = Hex.decode((String)line.substring(a + 1).trim());
                line = resourceReader.readLine();
                a = line.indexOf("=");
                byte[] ss = Hex.decode((String)line.substring(a + 1).trim());
                if (sampler.skipTest(count)) continue;
                NISTSecureRandom random = new NISTSecureRandom(seed, null);
                SNTRUPrimeKeyPairGenerator keyPairGenerator = new SNTRUPrimeKeyPairGenerator();
                keyPairGenerator.init((KeyGenerationParameters)new SNTRUPrimeKeyGenerationParameters((SecureRandom)random, paramSpec));
                AsymmetricCipherKeyPair keyPair = keyPairGenerator.generateKeyPair();
                Assert.assertTrue((boolean)Arrays.areEqual((byte[])pk, (byte[])((SNTRUPrimePublicKeyParameters)keyPair.getPublic()).getEncoded()));
                Assert.assertTrue((boolean)Arrays.areEqual((byte[])sk, (byte[])((SNTRUPrimePrivateKeyParameters)keyPair.getPrivate()).getEncoded()));
                SNTRUPrimeKEMGenerator kemGenerator = new SNTRUPrimeKEMGenerator((SecureRandom)random);
                SecretWithEncapsulation secretEncapsulation = kemGenerator.generateEncapsulated(keyPair.getPublic());
                Assert.assertTrue((boolean)Arrays.areEqual((byte[])ct, (byte[])secretEncapsulation.getEncapsulation()));
                byte[] secret = secretEncapsulation.getSecret();
                Assert.assertTrue((boolean)Arrays.areEqual((byte[])ss, (int)0, (int)secret.length, (byte[])secret, (int)0, (int)secret.length));
                SNTRUPrimeKEMExtractor kemExtractor = new SNTRUPrimeKEMExtractor((SNTRUPrimePrivateKeyParameters)keyPair.getPrivate());
                byte[] decryptedSecret = kemExtractor.extractSecret(ct);
                Assert.assertTrue((boolean)Arrays.areEqual((byte[])ss, (int)0, (int)decryptedSecret.length, (byte[])decryptedSecret, (int)0, (int)decryptedSecret.length));
            }
            resource.close();
            ++i;
        }
    }
}

