/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.saber.SABERKEMExtractor;
import org.bouncycastle.pqc.crypto.saber.SABERKEMGenerator;
import org.bouncycastle.pqc.crypto.saber.SABERKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.saber.SABERKeyPairGenerator;
import org.bouncycastle.pqc.crypto.saber.SABERKeyParameters;
import org.bouncycastle.pqc.crypto.saber.SABERParameters;
import org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SABERVectorTest
extends TestCase {
    public void testParameters() throws Exception {
        Assert.assertEquals((int)128, (int)SABERParameters.lightsaberkem128r3.getSessionKeySize());
        Assert.assertEquals((int)128, (int)SABERParameters.saberkem128r3.getSessionKeySize());
        Assert.assertEquals((int)128, (int)SABERParameters.firesaberkem128r3.getSessionKeySize());
        Assert.assertEquals((int)192, (int)SABERParameters.lightsaberkem192r3.getSessionKeySize());
        Assert.assertEquals((int)192, (int)SABERParameters.saberkem192r3.getSessionKeySize());
        Assert.assertEquals((int)192, (int)SABERParameters.firesaberkem192r3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)SABERParameters.lightsaberkem256r3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)SABERParameters.saberkem256r3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)SABERParameters.firesaberkem256r3.getSessionKeySize());
    }

    public void testVectors() throws Exception {
        SABERParameters[] params = new SABERParameters[]{SABERParameters.lightsaberkem256r3, SABERParameters.saberkem256r3, SABERParameters.firesaberkem256r3, SABERParameters.ulightsaberkemr3, SABERParameters.usaberkemr3, SABERParameters.ufiresaberkemr3, SABERParameters.lightsaberkem90sr3, SABERParameters.saberkem90sr3, SABERParameters.firesaberkem90sr3, SABERParameters.ulightsaberkem90sr3, SABERParameters.usaberkem90sr3, SABERParameters.ufiresaberkem90sr3};
        String[] files = new String[]{"lightsaber.rsp", "saber.rsp", "firesaber.rsp", "ulightsaber.rsp", "usaber.rsp", "ufiresaber.rsp", "lightsaber-90s.rsp", "saber-90s.rsp", "firesaber-90s.rsp", "ulightsaber-90s.rsp", "usaber-90s.rsp", "ufiresaber-90s.rsp"};
        TestSampler sampler = new TestSampler();
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/saber", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] ct = Hex.decode((String)((String)buf.get("ct")));
                        byte[] ss = Hex.decode((String)((String)buf.get("ss")));
                        NISTSecureRandom random = new NISTSecureRandom(seed, null);
                        SABERParameters parameters = params[fileIndex];
                        SABERKeyPairGenerator kpGen = new SABERKeyPairGenerator();
                        SABERKeyGenerationParameters genParam = new SABERKeyGenerationParameters((SecureRandom)random, parameters);
                        kpGen.init((KeyGenerationParameters)genParam);
                        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                        SABERPublicKeyParameters pubParams = (SABERPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((SABERPublicKeyParameters)kp.getPublic())));
                        SABERPrivateKeyParameters privParams = (SABERPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((SABERPrivateKeyParameters)kp.getPrivate())));
                        Assert.assertTrue((String)(name + " " + count + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])pubParams.getPublicKey()));
                        Assert.assertTrue((String)(name + " " + count + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])privParams.getPrivateKey()));
                        SABERKEMGenerator SABEREncCipher = new SABERKEMGenerator((SecureRandom)random);
                        SecretWithEncapsulation secWenc = SABEREncCipher.generateEncapsulated((AsymmetricKeyParameter)pubParams);
                        byte[] generated_cipher_text = secWenc.getEncapsulation();
                        Assert.assertTrue((String)(name + " " + count + ": kem_enc cipher text"), (boolean)Arrays.areEqual((byte[])ct, (byte[])generated_cipher_text));
                        byte[] secret = secWenc.getSecret();
                        Assert.assertTrue((String)(name + " " + count + ": kem_enc key"), (boolean)Arrays.areEqual((byte[])ss, (byte[])secret));
                        SABERKEMExtractor SABERDecCipher = new SABERKEMExtractor((SABERKeyParameters)privParams);
                        byte[] dec_key = SABERDecCipher.extractSecret(generated_cipher_text);
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec ss"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])ss));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec key"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])secret));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }
}

