/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.picnic.PicnicKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.picnic.PicnicKeyPairGenerator;
import org.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import org.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import org.bouncycastle.pqc.crypto.picnic.PicnicSigner;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class PicnicVectorTest
extends TestCase {
    public void testParameters() throws Exception {
    }

    public void testVectors() throws Exception {
        PicnicParameters[] params;
        String[] files;
        boolean full = System.getProperty("test.full", "false").equals("true");
        if (full) {
            files = new String[]{"picnicl1fs.rsp", "picnicl1ur.rsp", "picnicl3fs.rsp", "picnicl3ur.rsp", "picnicl5fs.rsp", "picnicl5ur.rsp", "picnic3l1.rsp", "picnic3l3.rsp", "picnic3l5.rsp", "picnicl1full.rsp", "picnicl3full.rsp", "picnicl5full.rsp"};
            params = new PicnicParameters[]{PicnicParameters.picnicl1fs, PicnicParameters.picnicl1ur, PicnicParameters.picnicl3fs, PicnicParameters.picnicl3ur, PicnicParameters.picnicl5fs, PicnicParameters.picnicl5ur, PicnicParameters.picnic3l1, PicnicParameters.picnic3l3, PicnicParameters.picnic3l5, PicnicParameters.picnicl1full, PicnicParameters.picnicl3full, PicnicParameters.picnicl5full};
        } else {
            files = new String[]{"picnicl1fs.rsp", "picnic3l1.rsp", "picnicl3ur.rsp", "picnicl1full.rsp"};
            params = new PicnicParameters[]{PicnicParameters.picnicl1fs, PicnicParameters.picnic3l1, PicnicParameters.picnicl3ur, PicnicParameters.picnicl1full};
        }
        TestSampler sampler = new TestSampler();
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/picnic", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        int mlen = Integer.parseInt((String)buf.get("mlen"));
                        byte[] msg = Hex.decode((String)((String)buf.get("msg")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        int smlen = Integer.parseInt((String)buf.get("smlen"));
                        byte[] sigExpected = Hex.decode((String)((String)buf.get("sm")));
                        NISTSecureRandom random = new NISTSecureRandom(seed, null);
                        PicnicParameters parameters = params[fileIndex];
                        PicnicKeyPairGenerator kpGen = new PicnicKeyPairGenerator();
                        PicnicKeyGenerationParameters genParams = new PicnicKeyGenerationParameters((SecureRandom)random, parameters);
                        kpGen.init((KeyGenerationParameters)genParams);
                        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                        PicnicPublicKeyParameters pubParams = (PicnicPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)kp.getPublic()));
                        PicnicPrivateKeyParameters privParams = (PicnicPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)kp.getPrivate()));
                        Assert.assertTrue((String)(name + " " + count + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])pubParams.getEncoded()));
                        Assert.assertTrue((String)(name + " " + count + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])privParams.getEncoded()));
                        PicnicSigner signer = new PicnicSigner();
                        signer.init(true, (CipherParameters)privParams);
                        byte[] sigGenerated = signer.generateSignature(msg);
                        byte[] attachedSig = Arrays.concatenate((byte[])Pack.intToLittleEndian((int)sigGenerated.length), (byte[])msg, (byte[])sigGenerated);
                        Assert.assertEquals((String)(name + " " + count + ": signature length"), (int)smlen, (int)attachedSig.length);
                        signer.init(false, (CipherParameters)pubParams);
                        Assert.assertTrue((String)(name + " " + count + ": signature verify"), (boolean)signer.verifySignature(msg, sigGenerated));
                        Assert.assertTrue((String)(name + " " + count + ": signature gen match"), (boolean)Arrays.areEqual((byte[])sigExpected, (byte[])attachedSig));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }

    public void testPicnicRandom() {
        byte[] msg = Strings.toByteArray((String)"Hello World!");
        PicnicKeyPairGenerator keyGen = new PicnicKeyPairGenerator();
        SecureRandom random = new SecureRandom();
        keyGen.init((KeyGenerationParameters)new PicnicKeyGenerationParameters(random, PicnicParameters.picnic3l1));
        int i = 0;
        while (i != 100) {
            AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();
            PicnicSigner signer = new PicnicSigner();
            PicnicPrivateKeyParameters skparam = (PicnicPrivateKeyParameters)keyPair.getPrivate();
            signer.init(true, (CipherParameters)skparam);
            byte[] sigGenerated = signer.generateSignature(msg);
            PicnicSigner verifier = new PicnicSigner();
            PicnicPublicKeyParameters pkparam = (PicnicPublicKeyParameters)keyPair.getPublic();
            verifier.init(false, (CipherParameters)pkparam);
            Assert.assertTrue((String)("count = " + i), (boolean)verifier.verifySignature(msg, sigGenerated));
            ++i;
        }
    }
}

