/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.util.DEROtherInfo;
import org.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.pqc.crypto.ExchangePair;
import org.bouncycastle.pqc.crypto.newhope.NHAgreement;
import org.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import org.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import org.bouncycastle.pqc.crypto.newhope.NHOtherInfoGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NewHopeTest
extends SimpleTest {
    private static final int ROUNDS = 1000;

    private void testKeyExchange() throws Exception {
        SecureRandom aliceRand = new SecureRandom();
        SecureRandom bobRand = new SecureRandom();
        int i = 0;
        while (i < 1000) {
            NHKeyPairGenerator kpGen = new NHKeyPairGenerator();
            kpGen.init(new KeyGenerationParameters(aliceRand, 2048));
            AsymmetricCipherKeyPair aliceKp = kpGen.generateKeyPair();
            NHExchangePairGenerator exchGen = new NHExchangePairGenerator(bobRand);
            ExchangePair bobExchPair = exchGen.generateExchange(aliceKp.getPublic());
            NHAgreement agreement = new NHAgreement();
            agreement.init((CipherParameters)aliceKp.getPrivate());
            byte[] aliceSharedKey = agreement.calculateAgreement((CipherParameters)bobExchPair.getPublicKey());
            this.isTrue("value mismatch", Arrays.areEqual((byte[])aliceSharedKey, (byte[])bobExchPair.getSharedValue()));
            ++i;
        }
    }

    private void testPrivInfoGeneration() throws IOException {
        SecureRandom random = new SecureRandom();
        NHOtherInfoGenerator.PartyU partyU = new NHOtherInfoGenerator.PartyU(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode((String)"beef"), Hex.decode((String)"cafe"), random);
        byte[] partA = partyU.getSuppPrivInfoPartA();
        NHOtherInfoGenerator.PartyV partyV = new NHOtherInfoGenerator.PartyV(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode((String)"beef"), Hex.decode((String)"cafe"), random);
        byte[] partB = partyV.getSuppPrivInfoPartB(partA);
        DEROtherInfo otherInfoU = partyU.generate(partB);
        DEROtherInfo otherInfoV = partyV.generate();
        this.areEqual(otherInfoU.getEncoded(), otherInfoV.getEncoded());
    }

    private void testReuse() throws IOException {
        SecureRandom random = new SecureRandom();
        NHOtherInfoGenerator.PartyU partyU = new NHOtherInfoGenerator.PartyU(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode((String)"beef"), Hex.decode((String)"cafe"), random);
        byte[] partA = partyU.getSuppPrivInfoPartA();
        NHOtherInfoGenerator.PartyV partyV = new NHOtherInfoGenerator.PartyV(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode((String)"beef"), Hex.decode((String)"cafe"), random);
        byte[] partB = partyV.getSuppPrivInfoPartB(partA);
        DEROtherInfo otherInfoU = partyU.generate(partB);
        DEROtherInfo otherInfoV = partyV.generate();
        this.areEqual(otherInfoU.getEncoded(), otherInfoV.getEncoded());
        try {
            partyV.generate();
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("builder already used", e.getMessage());
        }
        try {
            partyU.generate(partB);
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("builder already used", e.getMessage());
        }
    }

    private void testInterop() {
    }

    public String getName() {
        return "NewHope";
    }

    public void performTest() throws Exception {
        this.testKeyExchange();
        this.testInterop();
        this.testPrivInfoGeneration();
        this.testReuse();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new NewHopeTest());
    }
}

