/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.test.FixedSecureRandom;

public class NISTSecureRandom
extends SecureRandom {
    private byte[] seed;
    private byte[] personalization;
    private byte[] key;
    private byte[] v;

    public static FixedSecureRandom getFixed(byte[] seed, int strength) {
        return NISTSecureRandom.getFixed(seed, null, strength, strength / 8, strength / 8);
    }

    public static FixedSecureRandom getFixed(byte[] seed, byte[] personalization, int strength, int discard, int size) {
        NISTSecureRandom cmceRNG = new NISTSecureRandom(seed, personalization);
        cmceRNG.init(strength);
        byte[] burn = new byte[discard];
        cmceRNG.nextBytes(burn);
        if (discard != size) {
            burn = new byte[size];
        }
        cmceRNG.nextBytes(burn);
        return new FixedSecureRandom(burn);
    }

    public static FixedSecureRandom getFixedNoDiscard(byte[] seed, int strength) {
        NISTSecureRandom cmceRNG = new NISTSecureRandom(seed, null);
        cmceRNG.init(strength);
        byte[] burn = new byte[strength / 8];
        cmceRNG.nextBytes(burn);
        return new FixedSecureRandom(burn);
    }

    public NISTSecureRandom(byte[] seed, byte[] personalization) {
        this.seed = seed;
        this.personalization = personalization;
        this.init(256);
    }

    private void init(int strength) {
        this.randombytes_init(this.seed, this.personalization, strength);
    }

    public void nextBytes(byte[] x) {
        byte[] block = new byte[16];
        int i = 0;
        int xlen = x.length;
        while (xlen > 0) {
            int j = 15;
            while (j >= 0) {
                if ((this.v[j] & 0xFF) != 255) {
                    int n = j;
                    this.v[n] = (byte)(this.v[n] + 1);
                    break;
                }
                this.v[j] = 0;
                --j;
            }
            this.AES256_ECB(this.key, this.v, block, 0);
            if (xlen > 15) {
                System.arraycopy(block, 0, x, i, block.length);
                i += 16;
                xlen -= 16;
                continue;
            }
            System.arraycopy(block, 0, x, i, xlen);
            xlen = 0;
        }
        this.AES256_CTR_DRBG_Update(null, this.key, this.v);
    }

    private void AES256_ECB(byte[] key, byte[] ctr, byte[] buffer, int startPosition) {
        try {
            AESEngine cipher = new AESEngine();
            cipher.init(true, (CipherParameters)new KeyParameter(key));
            int i = 0;
            while (i != ctr.length) {
                cipher.processBlock(ctr, i, buffer, startPosition + i);
                i += 16;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private void AES256_CTR_DRBG_Update(byte[] entropy_input, byte[] key, byte[] v) {
        byte[] tmp = new byte[48];
        int i = 0;
        while (i < 3) {
            int j = 15;
            while (j >= 0) {
                if ((v[j] & 0xFF) != 255) {
                    int n = j;
                    v[n] = (byte)(v[n] + 1);
                    break;
                }
                v[j] = 0;
                --j;
            }
            this.AES256_ECB(key, v, tmp, 16 * i);
            ++i;
        }
        if (entropy_input != null) {
            int i2 = 0;
            while (i2 < 48) {
                int n = i2;
                tmp[n] = (byte)(tmp[n] ^ entropy_input[i2]);
                ++i2;
            }
        }
        System.arraycopy(tmp, 0, key, 0, key.length);
        System.arraycopy(tmp, 32, v, 0, v.length);
    }

    private void randombytes_init(byte[] entropyInput, byte[] personalization, int strength) {
        byte[] seedMaterial = new byte[48];
        System.arraycopy(entropyInput, 0, seedMaterial, 0, seedMaterial.length);
        if (personalization != null) {
            int i = 0;
            while (i < 48) {
                int n = i;
                seedMaterial[n] = (byte)(seedMaterial[n] ^ personalization[i]);
                ++i;
            }
        }
        this.key = new byte[32];
        this.v = new byte[16];
        this.AES256_CTR_DRBG_Update(seedMaterial, this.key, this.v);
    }
}

