/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSASigner;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestUtils;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;

public class MLDSATest
extends TestCase {
    private static final Map PARAMETERS_MAP = new HashMap(){
        {
            this.put("ML-DSA-44", MLDSAParameters.ml_dsa_44);
            this.put("ML-DSA-65", MLDSAParameters.ml_dsa_65);
            this.put("ML-DSA-87", MLDSAParameters.ml_dsa_87);
        }
    };
    private static final MLDSAParameters[] PARAMETER_SETS = new MLDSAParameters[]{MLDSAParameters.ml_dsa_44, MLDSAParameters.ml_dsa_65, MLDSAParameters.ml_dsa_87};

    public void testConsistency() throws Exception {
        SecureRandom random = new SecureRandom();
        MLDSAKeyPairGenerator kpg = new MLDSAKeyPairGenerator();
        int idx = 0;
        while (idx != PARAMETER_SETS.length) {
            MLDSAParameters parameters = PARAMETER_SETS[idx];
            kpg.init((KeyGenerationParameters)new MLDSAKeyGenerationParameters(random, parameters));
            int msgSize = 0;
            do {
                byte[] msg = new byte[msgSize];
                int i = 0;
                while (i < 2) {
                    AsymmetricCipherKeyPair kp = kpg.generateKeyPair();
                    MLDSASigner signer = new MLDSASigner();
                    int j = 0;
                    while (j < 2) {
                        random.nextBytes(msg);
                        signer.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)kp.getPrivate(), random));
                        signer.update(msg, 0, msg.length);
                        byte[] signature = signer.generateSignature();
                        signer.init(false, (CipherParameters)kp.getPublic());
                        signer.update(msg, 0, msg.length);
                        boolean shouldVerify = signer.verifySignature(signature);
                        Assert.assertTrue((String)("count = " + i), (boolean)shouldVerify);
                        ++j;
                    }
                    ++i;
                }
            } while ((msgSize += msgSize < 128 ? 1 : 17) <= 2048);
            ++idx;
        }
    }

    public void testKeyGen() throws IOException {
        String[] files = new String[]{"keyGen_ML-DSA-44.txt", "keyGen_ML-DSA-65.txt", "keyGen_ML-DSA-87.txt"};
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/dilithium/acvp", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        FixedSecureRandom random = new FixedSecureRandom(seed);
                        MLDSAParameters parameters = PARAMETER_SETS[fileIndex];
                        MLDSAKeyPairGenerator kpGen = new MLDSAKeyPairGenerator();
                        kpGen.init((KeyGenerationParameters)new MLDSAKeyGenerationParameters((SecureRandom)random, parameters));
                        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                        MLDSAPublicKeyParameters pubParams = (MLDSAPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)kp.getPublic()));
                        MLDSAPrivateKeyParameters privParams = (MLDSAPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)kp.getPrivate()));
                        Assert.assertTrue((String)(name + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])pubParams.getEncoded()));
                        Assert.assertTrue((String)(name + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])privParams.getEncoded()));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }

    public void testSigGen() throws IOException {
        String[] files = new String[]{"sigGen_ML-DSA-44.txt", "sigGen_ML-DSA-65.txt", "sigGen_ML-DSA-87.txt"};
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/dilithium/acvp", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        boolean deterministic = !buf.containsKey("rnd");
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] message = Hex.decode((String)((String)buf.get("message")));
                        byte[] signature = Hex.decode((String)((String)buf.get("signature")));
                        byte[] rnd = new byte[32];
                        if (!deterministic) {
                            rnd = Hex.decode((String)((String)buf.get("rnd")));
                        }
                        MLDSAParameters parameters = PARAMETER_SETS[fileIndex];
                        MLDSAPrivateKeyParameters privParams = new MLDSAPrivateKeyParameters(parameters, sk, null);
                        InternalMLDSASigner signer = new InternalMLDSASigner();
                        signer.init(true, (CipherParameters)privParams);
                        byte[] sigGenerated = signer.internalGenerateSignature(message, rnd);
                        Assert.assertTrue((boolean)Arrays.areEqual((byte[])sigGenerated, (byte[])signature));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }

    public void testSigVer() throws IOException {
        String[] files = new String[]{"sigVer_ML-DSA-44.txt", "sigVer_ML-DSA-65.txt", "sigVer_ML-DSA-87.txt"};
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/dilithium/acvp", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        boolean testPassed = TestUtils.parseBoolean((String)buf.get("testPassed"));
                        String reason = (String)buf.get("reason");
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] message = Hex.decode((String)((String)buf.get("message")));
                        byte[] signature = Hex.decode((String)((String)buf.get("signature")));
                        MLDSAParameters parameters = PARAMETER_SETS[fileIndex];
                        MLDSAPublicKeyParameters pubParams = new MLDSAPublicKeyParameters(parameters, pk);
                        InternalMLDSASigner verifier = new InternalMLDSASigner();
                        verifier.init(false, (CipherParameters)pubParams);
                        boolean ver = verifier.internalVerifySignature(message, signature);
                        Assert.assertEquals((String)("expected " + testPassed + " " + reason), (boolean)testPassed, (boolean)ver);
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }

    public void testRNG() {
        String temp = "061550234D158C5EC95595FE04EF7A25767F2E24CC2BC479D09D86DC9ABCFDE7056A8C266F9EF97ED08541DBD2E1FFA1";
        byte[] seed = Hex.decode((String)temp);
        NISTSecureRandom r = new NISTSecureRandom(seed, null);
        String testBytesString = "7C9935A0B07694AA0C6D10E4DB6B1ADD2FD81A25CCB148032DCD739936737F2D";
        byte[] testBytes = Hex.decode((String)testBytesString);
        byte[] randBytes = new byte[testBytes.length];
        r.nextBytes(randBytes);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])randBytes, (byte[])testBytes));
    }

    public void testKeyGenCombinedVectorSet() throws IOException {
        InputStream src = TestResourceFinder.findTestResource("pqc/crypto/mldsa", "ML-DSA-keyGen.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        String line = null;
        HashMap<String, String> buf = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.length() == 0) {
                if (buf.size() > 0) {
                    byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                    byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                    byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                    FixedSecureRandom random = new FixedSecureRandom(seed);
                    MLDSAParameters parameters = (MLDSAParameters)PARAMETERS_MAP.get((String)buf.get("parameterSet"));
                    MLDSAKeyPairGenerator kpGen = new MLDSAKeyPairGenerator();
                    kpGen.init((KeyGenerationParameters)new MLDSAKeyGenerationParameters((SecureRandom)random, parameters));
                    AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                    MLDSAPublicKeyParameters pubParams = (MLDSAPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)kp.getPublic()));
                    MLDSAPrivateKeyParameters privParams = (MLDSAPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)kp.getPrivate()));
                    Assert.assertTrue((boolean)Arrays.areEqual((byte[])pk, (byte[])pubParams.getEncoded()));
                    Assert.assertTrue((boolean)Arrays.areEqual((byte[])sk, (byte[])privParams.getEncoded()));
                }
                buf.clear();
                continue;
            }
            int a = line.indexOf("=");
            if (a <= -1) continue;
            buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
        }
    }

    public void testSigGenCombinedVectorSet() throws IOException {
        InputStream src = TestResourceFinder.findTestResource("pqc/crypto/mldsa", "ML-DSA-sigGen.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        String line = null;
        HashMap<String, String> buf = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.length() == 0) {
                if (buf.size() > 0) {
                    boolean deterministic = TestUtils.parseBoolean((String)buf.get("deterministic"));
                    byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                    byte[] message = Hex.decode((String)((String)buf.get("message")));
                    byte[] signature = Hex.decode((String)((String)buf.get("signature")));
                    byte[] rnd = null;
                    rnd = !deterministic ? Hex.decode((String)((String)buf.get("rnd"))) : new byte[32];
                    MLDSAParameters parameters = (MLDSAParameters)PARAMETERS_MAP.get((String)buf.get("parameterSet"));
                    MLDSAPrivateKeyParameters privParams = new MLDSAPrivateKeyParameters(parameters, sk, null);
                    InternalMLDSASigner signer = new InternalMLDSASigner();
                    signer.init(true, (CipherParameters)privParams);
                    byte[] sigGenerated = signer.internalGenerateSignature(message, rnd);
                    Assert.assertTrue((boolean)Arrays.areEqual((byte[])sigGenerated, (byte[])signature));
                }
                buf.clear();
                continue;
            }
            int a = line.indexOf("=");
            if (a <= -1) continue;
            buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
        }
    }

    public void testSigVerCombinedVectorSet() throws IOException {
        InputStream src = TestResourceFinder.findTestResource("pqc/crypto/mldsa", "ML-DSA-sigVer.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        String line = null;
        HashMap<String, String> buf = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.length() == 0) {
                if (!buf.isEmpty()) {
                    boolean expectedResult = TestUtils.parseBoolean((String)buf.get("testPassed"));
                    byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                    byte[] message = Hex.decode((String)((String)buf.get("message")));
                    byte[] signature = Hex.decode((String)((String)buf.get("signature")));
                    MLDSAParameters parameters = (MLDSAParameters)PARAMETERS_MAP.get((String)buf.get("parameterSet"));
                    MLDSAPublicKeyParameters pubParams = new MLDSAPublicKeyParameters(parameters, pk);
                    InternalMLDSASigner verifier = new InternalMLDSASigner();
                    verifier.init(false, (CipherParameters)pubParams);
                    boolean verifyResult = verifier.internalVerifySignature(message, signature);
                    Assert.assertEquals((boolean)expectedResult, (boolean)verifyResult);
                }
                buf.clear();
                continue;
            }
            int a = line.indexOf("=");
            if (a <= -1) continue;
            buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
        }
    }

    private class InternalMLDSASigner
    extends MLDSASigner {
        private InternalMLDSASigner() {
        }

        public byte[] internalGenerateSignature(byte[] message, byte[] rnd) {
            return super.internalGenerateSignature(message, rnd);
        }

        public boolean internalVerifySignature(byte[] message, byte[] signature) {
            return super.internalVerifySignature(message, signature);
        }
    }
}

