/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.hqc.HQCKEMExtractor;
import org.bouncycastle.pqc.crypto.hqc.HQCKEMGenerator;
import org.bouncycastle.pqc.crypto.hqc.HQCKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCKeyPairGenerator;
import org.bouncycastle.pqc.crypto.hqc.HQCParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;

public class HQCTest
extends TestCase {
    public String getName() {
        return "HQC Test";
    }

    public void testVectors() throws Exception {
        boolean full = System.getProperty("test.full", "false").equals("true");
        String[] files = new String[]{"hqc-128_kat.rsp", "hqc-192_kat.rsp", "hqc-256_kat.rsp"};
        HQCParameters[] listParams = new HQCParameters[]{HQCParameters.hqc128, HQCParameters.hqc192, HQCParameters.hqc256};
        TestSampler sampler = new TestSampler();
        int fileIndex = 0;
        while (fileIndex < files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/hqc", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            Random rnd = new Random(System.currentTimeMillis());
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] ct = Hex.decode((String)((String)buf.get("ct")));
                        byte[] ss = Hex.decode((String)((String)buf.get("ss")));
                        HQCParameters parameters = listParams[fileIndex];
                        HQCKeyPairGenerator hqcKeyGen = new HQCKeyPairGenerator();
                        HQCKeyGenerationParameters genParam = new HQCKeyGenerationParameters((SecureRandom)new FixedSecureRandom(seed), parameters);
                        hqcKeyGen.init((KeyGenerationParameters)genParam);
                        AsymmetricCipherKeyPair pair = hqcKeyGen.generateKeyPair();
                        HQCPublicKeyParameters generatedPk = (HQCPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((HQCPublicKeyParameters)pair.getPublic())));
                        HQCPrivateKeyParameters generatedSk = (HQCPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((HQCPrivateKeyParameters)pair.getPrivate())));
                        Assert.assertTrue((String)(name + " " + count + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])generatedPk.getPublicKey()));
                        Assert.assertTrue((String)(name + " " + count + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])generatedSk.getPrivateKey()));
                        HQCKEMGenerator hqcKemGenerator = new HQCKEMGenerator((SecureRandom)new FixedSecureRandom(seed));
                        SecretWithEncapsulation secretWithEnc = hqcKemGenerator.generateEncapsulated((AsymmetricKeyParameter)generatedPk);
                        byte[] secret = secretWithEnc.getSecret();
                        byte[] c = secretWithEnc.getEncapsulation();
                        Assert.assertTrue((String)(name + " " + count + ": ciphertext"), (boolean)Arrays.areEqual((byte[])c, (byte[])ct));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec ss"), (boolean)Arrays.areEqual((byte[])secret, (int)0, (int)secret.length, (byte[])ss, (int)0, (int)secret.length));
                        HQCKEMExtractor bikekemExtractor = new HQCKEMExtractor(generatedSk);
                        byte[] dec_key = bikekemExtractor.extractSecret(c);
                        Assert.assertEquals((int)parameters.getSessionKeySize(), (int)(secret.length * 8));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec key"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])secret));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }
}

