/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.frodo.FrodoKEMExtractor;
import org.bouncycastle.pqc.crypto.frodo.FrodoKEMGenerator;
import org.bouncycastle.pqc.crypto.frodo.FrodoKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoKeyPairGenerator;
import org.bouncycastle.pqc.crypto.frodo.FrodoKeyParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class FrodoVectorTest
extends TestCase {
    public void testParameters() throws Exception {
        Assert.assertEquals((int)128, (int)FrodoParameters.frodokem640aes.getSessionKeySize());
        Assert.assertEquals((int)128, (int)FrodoParameters.frodokem640shake.getSessionKeySize());
        Assert.assertEquals((int)192, (int)FrodoParameters.frodokem976aes.getSessionKeySize());
        Assert.assertEquals((int)192, (int)FrodoParameters.frodokem976shake.getSessionKeySize());
        Assert.assertEquals((int)256, (int)FrodoParameters.frodokem1344aes.getSessionKeySize());
        Assert.assertEquals((int)256, (int)FrodoParameters.frodokem1344shake.getSessionKeySize());
    }

    public void testVectors() throws Exception {
        String[] files = new String[]{"PQCkemKAT_19888.rsp", "PQCkemKAT_31296.rsp", "PQCkemKAT_43088.rsp", "PQCkemKAT_19888_shake.rsp", "PQCkemKAT_31296_shake.rsp", "PQCkemKAT_43088_shake.rsp"};
        FrodoParameters[] params = new FrodoParameters[]{FrodoParameters.frodokem640aes, FrodoParameters.frodokem976aes, FrodoParameters.frodokem1344aes, FrodoParameters.frodokem640shake, FrodoParameters.frodokem976shake, FrodoParameters.frodokem1344shake};
        TestSampler sampler = new TestSampler();
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/frodo", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] ct = Hex.decode((String)((String)buf.get("ct")));
                        byte[] ss = Hex.decode((String)((String)buf.get("ss")));
                        NISTSecureRandom random = new NISTSecureRandom(seed, null);
                        FrodoParameters parameters = params[fileIndex];
                        FrodoKeyPairGenerator kpGen = new FrodoKeyPairGenerator();
                        FrodoKeyGenerationParameters genParams = new FrodoKeyGenerationParameters((SecureRandom)random, parameters);
                        kpGen.init((KeyGenerationParameters)genParams);
                        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                        FrodoPublicKeyParameters pubParams = (FrodoPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((FrodoPublicKeyParameters)kp.getPublic())));
                        FrodoPrivateKeyParameters privParams = (FrodoPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((FrodoPrivateKeyParameters)kp.getPrivate())));
                        Assert.assertTrue((String)(name + " " + count + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])pubParams.getPublicKey()));
                        Assert.assertTrue((String)(name + " " + count + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])privParams.getPrivateKey()));
                        FrodoKEMGenerator frodoEncCipher = new FrodoKEMGenerator((SecureRandom)random);
                        SecretWithEncapsulation secWenc = frodoEncCipher.generateEncapsulated((AsymmetricKeyParameter)pubParams);
                        byte[] generated_cipher_text = secWenc.getEncapsulation();
                        Assert.assertTrue((String)(name + " " + count + ": kem_enc cipher text"), (boolean)Arrays.areEqual((byte[])ct, (byte[])generated_cipher_text));
                        byte[] secret = secWenc.getSecret();
                        Assert.assertTrue((String)(name + " " + count + ": kem_enc key"), (boolean)Arrays.areEqual((byte[])ss, (byte[])secret));
                        FrodoKEMExtractor frodoDecCipher = new FrodoKEMExtractor((FrodoKeyParameters)privParams);
                        byte[] dec_key = frodoDecCipher.extractSecret(generated_cipher_text);
                        Assert.assertEquals((int)parameters.getSessionKeySize(), (int)(dec_key.length * 8));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec ss"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])ss));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec key"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])secret));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }
}

