/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.falcon.FalconKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconKeyPairGenerator;
import org.bouncycastle.pqc.crypto.falcon.FalconParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import org.bouncycastle.pqc.crypto.falcon.FalconSigner;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class FalconTest
extends TestCase {
    public void testVectors() throws Exception {
        String[] files = new String[]{"falcon512-KAT.rsp", "falcon1024-KAT.rsp"};
        FalconParameters[] parameters = new FalconParameters[]{FalconParameters.falcon_512, FalconParameters.falcon_1024};
        TestSampler sampler = new TestSampler();
        int fileindex = 0;
        while (fileindex < files.length) {
            String name = files[fileindex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/falcon", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] sm = Hex.decode((String)((String)buf.get("sm")));
                        int sm_len = Integer.parseInt((String)buf.get("smlen"));
                        byte[] msg = Hex.decode((String)((String)buf.get("msg")));
                        int m_len = Integer.parseInt((String)buf.get("mlen"));
                        NISTSecureRandom random = new NISTSecureRandom(seed, null);
                        FalconKeyGenerationParameters kparam = new FalconKeyGenerationParameters((SecureRandom)random, parameters[fileindex]);
                        FalconKeyPairGenerator kpg = new FalconKeyPairGenerator();
                        kpg.init((KeyGenerationParameters)kparam);
                        AsymmetricCipherKeyPair kp = kpg.generateKeyPair();
                        FalconPublicKeyParameters pubParams = (FalconPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((FalconPublicKeyParameters)kp.getPublic())));
                        FalconPrivateKeyParameters privParams = (FalconPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((FalconPrivateKeyParameters)kp.getPrivate())));
                        byte[] respk = pubParams.getH();
                        byte[] ressk = privParams.getEncoded();
                        Assert.assertTrue((String)(name + " " + count + " public key"), (boolean)Arrays.areEqual((byte[])respk, (int)0, (int)respk.length, (byte[])pk, (int)1, (int)pk.length));
                        Assert.assertTrue((String)(name + " " + count + " secret key"), (boolean)Arrays.areEqual((byte[])ressk, (int)0, (int)ressk.length, (byte[])sk, (int)1, (int)sk.length));
                        FalconSigner signer = new FalconSigner();
                        ParametersWithRandom skwrand = new ParametersWithRandom((CipherParameters)kp.getPrivate(), (SecureRandom)random);
                        signer.init(true, (CipherParameters)skwrand);
                        byte[] sig = signer.generateSignature(msg);
                        byte[] ressm = new byte[2 + msg.length + sig.length];
                        ressm[0] = (byte)(sig.length - 40 >>> 8);
                        ressm[1] = (byte)(sig.length - 40);
                        System.arraycopy(sig, 1, ressm, 2, 40);
                        System.arraycopy(msg, 0, ressm, 42, msg.length);
                        ressm[42 + msg.length] = (byte)(32 + kparam.getParameters().getLogN());
                        System.arraycopy(sig, 41, ressm, 43 + msg.length, sig.length - 40 - 1);
                        FalconSigner verifier = new FalconSigner();
                        FalconPublicKeyParameters pkparam = (FalconPublicKeyParameters)kp.getPublic();
                        verifier.init(false, (CipherParameters)pkparam);
                        boolean vrfyrespass = verifier.verifySignature(msg, sig);
                        sig[11] = (byte)(sig[11] + 1);
                        boolean vrfyresfail = verifier.verifySignature(msg, sig);
                        Assert.assertTrue((String)(name + " " + count + " signature"), (boolean)Arrays.areEqual((byte[])ressm, (byte[])sm));
                        Assert.assertTrue((String)(name + " " + count + " verify failed when should pass"), (boolean)vrfyrespass);
                        Assert.assertFalse((String)(name + " " + count + " verify passed when should fail"), (boolean)vrfyresfail);
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileindex;
        }
    }

    public void testFalconRandom() {
        byte[] msg = Strings.toByteArray((String)"Hello World!");
        FalconKeyPairGenerator keyGen = new FalconKeyPairGenerator();
        SecureRandom random = new SecureRandom();
        keyGen.init((KeyGenerationParameters)new FalconKeyGenerationParameters(random, FalconParameters.falcon_512));
        int i = 0;
        while (i != 100) {
            AsymmetricCipherKeyPair keyPair = keyGen.generateKeyPair();
            FalconSigner signer = new FalconSigner();
            FalconPrivateKeyParameters skparam = (FalconPrivateKeyParameters)keyPair.getPrivate();
            ParametersWithRandom skwrand = new ParametersWithRandom((CipherParameters)skparam, random);
            signer.init(true, (CipherParameters)skwrand);
            byte[] sigGenerated = signer.generateSignature(msg);
            FalconSigner verifier = new FalconSigner();
            FalconPublicKeyParameters pkparam = (FalconPublicKeyParameters)keyPair.getPublic();
            verifier.init(false, (CipherParameters)pkparam);
            Assert.assertTrue((String)("count = " + i), (boolean)verifier.verifySignature(msg, sigGenerated));
            ++i;
        }
    }
}

