/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.cmce.CMCEKEMExtractor;
import org.bouncycastle.pqc.crypto.cmce.CMCEKEMGenerator;
import org.bouncycastle.pqc.crypto.cmce.CMCEKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEKeyPairGenerator;
import org.bouncycastle.pqc.crypto.cmce.CMCEParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class CMCEVectorTest
extends TestCase {
    public void testParameters() throws Exception {
        Assert.assertEquals((int)128, (int)CMCEParameters.mceliece348864r3.getSessionKeySize());
        Assert.assertEquals((int)128, (int)CMCEParameters.mceliece348864fr3.getSessionKeySize());
        Assert.assertEquals((int)192, (int)CMCEParameters.mceliece460896r3.getSessionKeySize());
        Assert.assertEquals((int)192, (int)CMCEParameters.mceliece460896fr3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)CMCEParameters.mceliece6688128r3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)CMCEParameters.mceliece6688128fr3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)CMCEParameters.mceliece6960119r3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)CMCEParameters.mceliece6960119fr3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)CMCEParameters.mceliece8192128r3.getSessionKeySize());
        Assert.assertEquals((int)256, (int)CMCEParameters.mceliece8192128fr3.getSessionKeySize());
    }

    public void testVectors() throws Exception {
        String[] files = new String[]{"3488-64-cmce.rsp", "3488-64-f-cmce.rsp", "4608-96-cmce.rsp", "4608-96-f-cmce.rsp", "6688-128-cmce.rsp", "6688-128-f-cmce.rsp", "6960-119-cmce.rsp", "6960-119-f-cmce.rsp", "8192-128-cmce.rsp", "8192-128-f-cmce.rsp"};
        CMCEParameters[] params = new CMCEParameters[]{CMCEParameters.mceliece348864r3, CMCEParameters.mceliece348864fr3, CMCEParameters.mceliece460896r3, CMCEParameters.mceliece460896fr3, CMCEParameters.mceliece6688128r3, CMCEParameters.mceliece6688128fr3, CMCEParameters.mceliece6960119r3, CMCEParameters.mceliece6960119fr3, CMCEParameters.mceliece8192128r3, CMCEParameters.mceliece8192128fr3};
        TestSampler sampler = new TestSampler();
        int fileIndex = 0;
        while (fileIndex != files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/cmce", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] ct = Hex.decode((String)((String)buf.get("ct")));
                        byte[] ss = Hex.decode((String)((String)buf.get("ss")));
                        NISTSecureRandom random = new NISTSecureRandom(seed, null);
                        CMCEParameters parameters = params[fileIndex];
                        CMCEKeyPairGenerator kpGen = new CMCEKeyPairGenerator();
                        CMCEKeyGenerationParameters genParam = new CMCEKeyGenerationParameters((SecureRandom)random, parameters);
                        kpGen.init((KeyGenerationParameters)genParam);
                        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
                        CMCEPublicKeyParameters pubParams = (CMCEPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((CMCEPublicKeyParameters)kp.getPublic())));
                        CMCEPrivateKeyParameters privParams = (CMCEPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((CMCEPrivateKeyParameters)kp.getPrivate())));
                        Assert.assertTrue((String)(name + " " + count + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])pubParams.getPublicKey()));
                        Assert.assertTrue((String)(name + " " + count + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])privParams.getPrivateKey()));
                        CMCEKEMGenerator cmceEncCipher = new CMCEKEMGenerator((SecureRandom)random);
                        SecretWithEncapsulation secWenc = cmceEncCipher.generateEncapsulated((AsymmetricKeyParameter)pubParams, 256);
                        byte[] generated_cipher_text = secWenc.getEncapsulation();
                        Assert.assertTrue((String)(name + " " + count + ": kem_enc cipher text"), (boolean)Arrays.areEqual((byte[])ct, (byte[])generated_cipher_text));
                        byte[] secret = secWenc.getSecret();
                        Assert.assertTrue((String)(name + " " + count + ": kem_enc key"), (boolean)Arrays.areEqual((byte[])ss, (byte[])secret));
                        CMCEKEMExtractor cmceDecCipher = new CMCEKEMExtractor(privParams);
                        byte[] dec_key = cmceDecCipher.extractSecret(generated_cipher_text, 256);
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec ss"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])ss));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec key"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])secret));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }
}

