/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.bike.BIKEKEMExtractor;
import org.bouncycastle.pqc.crypto.bike.BIKEKEMGenerator;
import org.bouncycastle.pqc.crypto.bike.BIKEKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEKeyPairGenerator;
import org.bouncycastle.pqc.crypto.bike.BIKEParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import org.bouncycastle.pqc.crypto.test.NISTSecureRandom;
import org.bouncycastle.pqc.crypto.test.TestSampler;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class BIKETest
extends TestCase {
    public String getName() {
        return "BIKE Test";
    }

    public void testVectors() throws Exception {
        String[] files = new String[]{"PQCkemKAT_BIKE_3114.rsp", "PQCkemKAT_BIKE_6198.rsp", "PQCkemKAT_BIKE_10276.rsp"};
        BIKEParameters[] listParams = new BIKEParameters[]{BIKEParameters.bike128, BIKEParameters.bike192, BIKEParameters.bike256};
        TestSampler sampler = new TestSampler();
        int fileIndex = 0;
        while (fileIndex < files.length) {
            String name = files[fileIndex];
            InputStream src = TestResourceFinder.findTestResource("pqc/crypto/bike", name);
            BufferedReader bin = new BufferedReader(new InputStreamReader(src));
            String line = null;
            HashMap<String, String> buf = new HashMap<String, String>();
            Random rnd = new Random(System.currentTimeMillis());
            while ((line = bin.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.length() == 0) {
                    if (buf.size() > 0) {
                        String count = (String)buf.get("count");
                        if (sampler.skipTest(count)) continue;
                        byte[] seed = Hex.decode((String)((String)buf.get("seed")));
                        byte[] pk = Hex.decode((String)((String)buf.get("pk")));
                        byte[] sk = Hex.decode((String)((String)buf.get("sk")));
                        byte[] ct = Hex.decode((String)((String)buf.get("ct")));
                        byte[] ss = Hex.decode((String)((String)buf.get("ss")));
                        NISTSecureRandom random = new NISTSecureRandom(seed, null);
                        BIKEParameters parameters = listParams[fileIndex];
                        BIKEKeyPairGenerator bikeKeyGen = new BIKEKeyPairGenerator();
                        BIKEKeyGenerationParameters genParam = new BIKEKeyGenerationParameters((SecureRandom)random, parameters);
                        bikeKeyGen.init((KeyGenerationParameters)genParam);
                        AsymmetricCipherKeyPair pair = bikeKeyGen.generateKeyPair();
                        BIKEPublicKeyParameters generatedPk = (BIKEPublicKeyParameters)PublicKeyFactory.createKey((SubjectPublicKeyInfo)SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((BIKEPublicKeyParameters)pair.getPublic())));
                        BIKEPrivateKeyParameters generatedSk = (BIKEPrivateKeyParameters)PrivateKeyFactory.createKey((PrivateKeyInfo)PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((BIKEPrivateKeyParameters)pair.getPrivate())));
                        Assert.assertTrue((String)(name + " " + count + ": public key"), (boolean)Arrays.areEqual((byte[])pk, (byte[])generatedPk.getEncoded()));
                        Assert.assertTrue((String)(name + " " + count + ": secret key"), (boolean)Arrays.areEqual((byte[])sk, (byte[])generatedSk.getEncoded()));
                        BIKEKEMGenerator bikekemGenerator = new BIKEKEMGenerator((SecureRandom)random);
                        SecretWithEncapsulation secretWithEnc = bikekemGenerator.generateEncapsulated((AsymmetricKeyParameter)generatedPk);
                        byte[] secret = secretWithEnc.getSecret();
                        byte[] c = secretWithEnc.getEncapsulation();
                        Assert.assertTrue((String)(name + " " + count + ": ciphertext"), (boolean)Arrays.areEqual((byte[])c, (byte[])ct));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec ss"), (boolean)Arrays.areEqual((byte[])secret, (int)0, (int)secret.length, (byte[])ss, (int)0, (int)secret.length));
                        BIKEKEMExtractor bikekemExtractor = new BIKEKEMExtractor(generatedSk);
                        byte[] dec_key = bikekemExtractor.extractSecret(c);
                        Assert.assertEquals((int)parameters.getSessionKeySize(), (int)(secret.length * 8));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec ss"), (boolean)Arrays.areEqual((byte[])dec_key, (int)0, (int)dec_key.length, (byte[])ss, (int)0, (int)dec_key.length));
                        Assert.assertTrue((String)(name + " " + count + ": kem_dec key"), (boolean)Arrays.areEqual((byte[])dec_key, (byte[])secret));
                    }
                    buf.clear();
                    continue;
                }
                int a = line.indexOf("=");
                if (a <= -1) continue;
                buf.put(line.substring(0, a).trim(), line.substring(a + 1).trim());
            }
            ++fileIndex;
        }
    }
}

