/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkix.test;

import java.math.BigInteger;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.pkix.SubjectPublicKeyInfoChecker;
import org.bouncycastle.util.encoders.Base64;

public class CheckerTest
extends TestCase {
    private static byte[] ecCert = Base64.decode((String)"MIIC0jCCAn2gAwIBAgIBATAKBggqhkjOPQQDAjCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTIyMDMxODAzMjYxNVoXDTIyMDMxODAzMjc1NVowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzCCASEwgd4GByqGSM49AgEwgdICAQEwKQYHKoZIzj0BAQIef///////////////f///////gAAAAAAAf///////MEAEHn///////////////3///////4AAAAAAAH///////AQeawFsO9zxiUHQ1lSSFHXKcanbL7J9HTd5YYXClCwKBD0ED/qWPNyogWzMM7hkK+35BcPTWFc9Pyf7vTs8uaqvfevo5OkKXa5uQFTKUwugRlSzaBjOIms5/Mt7AvGuAh5///////////////9///+eXpqfXZBx+9FSJoiQnQsCAQEDPgAETPwiEYy2zddyrIxd6pUb8+WeIpyIWhx663xy3Zi4R5GnrzZGOb1nKh/ne4hehT13Nw/jwUxdSvyfMub4MAoGCCqGSM49BAMCA0MAMEACHkNBhgQLlQ9c8Kv3o9xXuN8D53HsDaZLW9uDBovkpwIeeMwtBs2hflv3RsWASqKhb0LjvntYzgA3H7sXlekX");
    byte[] rsaCert = Base64.decode((String)"MIIDXjCCAsegAwIBAgIBBzANBgkqhkiG9w0BAQQFADCBtzELMAkGA1UEBhMCQVUxETAPBgNVBAgTCFZpY3RvcmlhMRgwFgYDVQQHEw9Tb3V0aCBNZWxib3VybmUxGjAYBgNVBAoTEUNvbm5lY3QgNCBQdHkgTHRkMR4wHAYDVQQLExVDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxFTATBgNVBAMTDENvbm5lY3QgNCBDQTEoMCYGCSqGSIb3DQEJARYZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTAeFw0wMDA2MDIwNzU2MjFaFw0wMTA2MDIwNzU2MjFaMIG4MQswCQYDVQQGEwJBVTERMA8GA1UECBMIVmljdG9yaWExGDAWBgNVBAcTD1NvdXRoIE1lbGJvdXJuZTEaMBgGA1UEChMRQ29ubmVjdCA0IFB0eSBMdGQxFzAVBgNVBAsTDldlYnNlcnZlciBUZWFtMR0wGwYDVQQDExR3d3cyLmNvbm5lY3Q0LmNvbS5hdTEoMCYGCSqGSIb3DQEJARYZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEArvDxclKAhyv7Q/Wmr2reGw4XL9Cnh9e+6VgWy2AWNy/MVeXdlxzd7QAuc1eOWQkGQEiLPy5XQtTY+sBUJ3AORvd2fEVJIcjf29ey7bYua9J/vz5MG2KYo9/WCHIwqD9mmG9g0xLcfwq/s8ZJBswE7sb85VU+h94PTvsWOsWuKaECAwEAAaN3MHUwJAYDVR0RBB0wG4EZd2VibWFzdGVyQGNvbm5lY3Q0LmNvbS5hdTA6BglghkgBhvhCAQ0ELRYrbW9kX3NzbCBnZW5lcmF0ZWQgY3VzdG9tIHNlcnZlciBjZXJ0aWZpY2F0ZTARBglghkgBhvhCAQEEBAMCBkAwDQYJKoZIhvcNAQEEBQADgYEAotccfKpwSsIxM1Hae8DR7M/Rw8dg/RqOWx45HNVLiBS4/3N/TO195yeQKbfmzbAA2jbPVvIvGgTxPgO1MP4ZgvgRhasaa0qCJCkWvpM4yQf33vOiYQbpv4rTwzU8AmRlBG45WdjyNIigGV+oRc61aKCTnLq7zB8N3z1TF/bF5/8=");
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger SEVEN = BigInteger.valueOf(7L);

    public void testECCert() throws Exception {
        SubjectPublicKeyInfo info = Certificate.getInstance((Object)ecCert).getSubjectPublicKeyInfo();
        SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
        AlgorithmIdentifier algId = info.getAlgorithm();
        X962Parameters x9params = X962Parameters.getInstance((Object)algId.getParameters());
        ASN1Sequence ecParameters = ASN1Sequence.getInstance((Object)x9params.getParameters());
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i != ecParameters.size()) {
            if (i == 1) {
                X9FieldID fId = X9FieldID.getInstance((Object)ecParameters.getObjectAt(1));
                v.add((ASN1Encodable)new X9FieldID(ASN1Integer.getInstance((Object)fId.getParameters()).getPositiveValue().multiply(BigInteger.valueOf(4L))));
            } else {
                v.add(ecParameters.getObjectAt(i));
            }
            ++i;
        }
        info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(algId.getAlgorithm(), (ASN1Encodable)new DERSequence(v)), info.getPublicKeyData().getBytes());
        try {
            SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Fp q value not prime", (String)e.getMessage());
        }
    }

    public void testRsaCert() throws Exception {
        SubjectPublicKeyInfo info = Certificate.getInstance((Object)this.rsaCert).getSubjectPublicKeyInfo();
        SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
        RSAPublicKey origKey = RSAPublicKey.getInstance((Object)info.parsePublicKey());
        info = new SubjectPublicKeyInfo(info.getAlgorithm(), (ASN1Encodable)new RSAPublicKey(origKey.getPublicExponent(), origKey.getModulus()));
        try {
            SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"RSA modulus is not composite", (String)e.getMessage());
        }
        info = new SubjectPublicKeyInfo(info.getAlgorithm(), (ASN1Encodable)new RSAPublicKey(origKey.getModulus().multiply(TWO), origKey.getPublicExponent()));
        try {
            SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"RSA modulus is even", (String)e.getMessage());
        }
        info = new SubjectPublicKeyInfo(info.getAlgorithm(), (ASN1Encodable)new RSAPublicKey(origKey.getModulus().multiply(SEVEN), origKey.getPublicExponent()));
        try {
            SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"RSA modulus has a small prime factor", (String)e.getMessage());
        }
        info = new SubjectPublicKeyInfo(info.getAlgorithm(), (ASN1Encodable)new RSAPublicKey(origKey.getModulus(), origKey.getPublicExponent().multiply(TWO)));
        try {
            SubjectPublicKeyInfoChecker.checkInfo((SubjectPublicKeyInfo)info);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"RSA publicExponent is even", (String)e.getMessage());
        }
    }
}

