/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.test;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;

public class AllTests
extends TestCase {
    private static final byte[] TEST_DATA = "Hello world!".getBytes();
    private static final String BC = "BC";

    public void setUp() {
        if (Security.getProvider(BC) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void testAlgorithmNameFinder() throws Exception {
        DefaultAlgorithmNameFinder nameFinder = new DefaultAlgorithmNameFinder();
        Assert.assertTrue((boolean)nameFinder.hasAlgorithmName(OIWObjectIdentifiers.elGamalAlgorithm));
        Assert.assertFalse((boolean)nameFinder.hasAlgorithmName(Extension.authorityKeyIdentifier));
        Assert.assertEquals((String)nameFinder.getAlgorithmName(OIWObjectIdentifiers.elGamalAlgorithm), (String)"ELGAMAL");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(PKCSObjectIdentifiers.rsaEncryption), (String)"RSA");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(PKCSObjectIdentifiers.id_RSAES_OAEP), (String)"RSAOAEP");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(PKCSObjectIdentifiers.md5), (String)"MD5");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(OIWObjectIdentifiers.idSHA1), (String)"SHA1");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(NISTObjectIdentifiers.id_sha224), (String)"SHA224");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(NISTObjectIdentifiers.id_sha256), (String)"SHA256");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(NISTObjectIdentifiers.id_sha384), (String)"SHA384");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(NISTObjectIdentifiers.id_sha512), (String)"SHA512");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(PKCSObjectIdentifiers.sha512WithRSAEncryption), (String)"SHA512WITHRSA");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(PKCSObjectIdentifiers.id_RSASSA_PSS), (String)"RSAPSS");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160), (String)"RIPEMD160WITHRSA");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, (ASN1Encodable)DERNull.INSTANCE)), (String)"ELGAMAL");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE)), (String)"RSA");
        Assert.assertEquals((String)nameFinder.getAlgorithmName(Extension.authorityKeyIdentifier), (String)Extension.authorityKeyIdentifier.getId());
    }

    public void testOaepWrap() throws Exception {
        KeyPairGenerator kGen = KeyPairGenerator.getInstance("RSA", BC);
        kGen.initialize(2048);
        KeyPair kp = kGen.generateKeyPair();
        this.checkAlgorithmId(kp, "SHA-1", OIWObjectIdentifiers.idSHA1);
        this.checkAlgorithmId(kp, "SHA-224", NISTObjectIdentifiers.id_sha224);
        this.checkAlgorithmId(kp, "SHA-256", NISTObjectIdentifiers.id_sha256);
        this.checkAlgorithmId(kp, "SHA-384", NISTObjectIdentifiers.id_sha384);
        this.checkAlgorithmId(kp, "SHA-512", NISTObjectIdentifiers.id_sha512);
        this.checkAlgorithmId(kp, "SHA-512/224", NISTObjectIdentifiers.id_sha512_224);
        this.checkAlgorithmId(kp, "SHA-512/256", NISTObjectIdentifiers.id_sha512_256);
        this.checkAlgorithmId(kp, "SHA-512(224)", NISTObjectIdentifiers.id_sha512_224);
        this.checkAlgorithmId(kp, "SHA-512(256)", NISTObjectIdentifiers.id_sha512_256);
    }

    private void checkAlgorithmId(KeyPair kp, String digest, ASN1ObjectIdentifier digestOid) {
    }
}

