/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.util.test.SimpleTest;

public class ParserTest
extends SimpleTest {
    static /* synthetic */ Class class$java$security$interfaces$DSAPrivateKey;
    static /* synthetic */ Class class$java$security$interfaces$RSAPrivateKey;

    public String getName() {
        return "PEMParserTest";
    }

    private PEMParser openPEMResource(String fileName) {
        InputStream res = this.getClass().getResourceAsStream(fileName);
        BufferedReader fRd = new BufferedReader(new InputStreamReader(res));
        return new PEMParser((Reader)fRd);
    }

    /*
     * WARNING - void declaration
     */
    public void performTest() throws Exception {
        Object privInfo;
        ASN1ObjectIdentifier ecOID;
        X9ECParameters ecSpec;
        Object o;
        PEMParser pemRd = this.openPEMResource("test.pem");
        while ((o = pemRd.readObject()) != null) {
            void var2_2;
            if (!(var2_2 instanceof KeyPair)) continue;
        }
        pemRd = this.openPEMResource("extratest.pem");
        while ((o = pemRd.readObject()) != null) {
            if (o instanceof X509CertificateHolder) continue;
            this.fail("wrong object found");
        }
        pemRd = this.openPEMResource("pkcs7.pem");
        ContentInfo d = (ContentInfo)pemRd.readObject();
        if (!d.getContentType().equals((ASN1Primitive)CMSObjectIdentifiers.envelopedData)) {
            this.fail("failed envelopedData check");
        }
        if ((ecSpec = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)(ecOID = (ASN1ObjectIdentifier)(pemRd = this.openPEMResource("eckey.pem")).readObject()))) == null) {
            this.fail("ecSpec not found for named curve");
        }
        PEMKeyPair pemPair = (PEMKeyPair)pemRd.readObject();
        KeyPair pair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        Signature sgr = Signature.getInstance("ECDSA", "BC");
        sgr.initSign(pair.getPrivate());
        byte[] message = new byte[]{97, 98, 99};
        sgr.update(message);
        byte[] sigBytes = sgr.sign();
        sgr.initVerify(pair.getPublic());
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("EC verification failed");
        }
        if (!pair.getPublic().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on public got: " + pair.getPublic().getAlgorithm());
        }
        if (!pair.getPrivate().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on private");
        }
        pemRd = this.openPEMResource("ecexpparam.pem");
        ecSpec = (X9ECParameters)pemRd.readObject();
        pemPair = (PEMKeyPair)pemRd.readObject();
        pair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        sgr = Signature.getInstance("ECDSA", "BC");
        sgr.initSign(pair.getPrivate());
        message = new byte[]{97, 98, 99};
        sgr.update(message);
        sigBytes = sgr.sign();
        sgr.initVerify(pair.getPublic());
        sgr.update(message);
        if (!sgr.verify(sigBytes)) {
            this.fail("EC verification failed");
        }
        if (!pair.getPublic().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on public got: " + pair.getPublic().getAlgorithm());
        }
        if (!pair.getPrivate().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on private");
        }
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        pair = kpGen.generateKeyPair();
        this.keyPairTest("RSA", pair);
        kpGen = KeyPairGenerator.getInstance("DSA", "BC");
        kpGen.initialize(512, new SecureRandom());
        pair = kpGen.generateKeyPair();
        this.keyPairTest("DSA", pair);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter((Writer)new OutputStreamWriter(bOut));
        pWrt.writeObject((Object)d);
        pWrt.close();
        pemRd = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        d = (ContentInfo)pemRd.readObject();
        if (!d.getContentType().equals((ASN1Primitive)CMSObjectIdentifiers.envelopedData)) {
            this.fail("failed envelopedData recode check");
        }
        this.doOpenSslDsaTest("unencrypted");
        this.doOpenSslRsaTest("unencrypted");
        this.doOpenSslTests("aes128");
        this.doOpenSslTests("aes192");
        this.doOpenSslTests("aes256");
        this.doOpenSslTests("blowfish");
        this.doOpenSslTests("des1");
        this.doOpenSslTests("des2");
        this.doOpenSslTests("des3");
        this.doOpenSslTests("rc2_128");
        this.doOpenSslDsaTest("rc2_40_cbc");
        this.doOpenSslRsaTest("rc2_40_cbc");
        this.doOpenSslDsaTest("rc2_64_cbc");
        this.doOpenSslRsaTest("rc2_64_cbc");
        this.doDudPasswordTest("7fd98", 0, "corrupted stream - out of bounds length found: 599005160 >= 19");
        this.doDudPasswordTest("ef677", 1, "corrupted stream - out of bounds length found: 2087569732 >= 66");
        this.doDudPasswordTest("800ce", 2, "unknown tag 26 encountered");
        this.doDudPasswordTest("b6cd8", 3, "DEF length 81 object truncated by 56");
        this.doDudPasswordTest("28ce09", 4, "corrupted stream - high tag number < 31 found");
        this.doDudPasswordTest("2ac3b9", 5, "long form definite-length more than 31 bits");
        this.doDudPasswordTest("2cba96", 6, "corrupted stream - out of bounds length found: 100 >= 67");
        this.doDudPasswordTest("2e3354", 7, "corrupted stream - out of bounds length found: 42 >= 35");
        this.doDudPasswordTest("2f4142", 8, "long form definite-length more than 31 bits");
        this.doDudPasswordTest("2fe9bb", 9, "long form definite-length more than 31 bits");
        this.doDudPasswordTest("3ee7a8", 10, "long form definite-length more than 31 bits");
        this.doDudPasswordTest("41af75", 11, "unknown tag 16 encountered");
        this.doDudPasswordTest("1704a5", 12, "corrupted stream detected");
        this.doDudPasswordTest("1c5822", 13, "Extra data detected in stream");
        this.doDudPasswordTest("5a3d16", 14, "corrupted stream detected");
        this.doDudPasswordTest("8d0c97", 15, "corrupted stream detected");
        this.doDudPasswordTest("bc0daf", 16, "corrupted stream detected");
        this.doDudPasswordTest("aaf9c4d", 17, "corrupted stream - out of bounds length found: 1580418590 >= 447");
        this.doNoPasswordTest();
        InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build("password".toCharArray());
        pemRd = this.openPEMResource("enckey.pem");
        PKCS8EncryptedPrivateKeyInfo encPrivKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemRd.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)converter.getPrivateKey(encPrivKeyInfo.decryptPrivateKeyInfo(pkcs8Prov));
        if (!privKey.getPublicExponent().equals(new BigInteger("10001", 16))) {
            this.fail("decryption of private key data check failed");
        }
        pemRd = this.openPEMResource("pkcs8test.pem");
        while ((privInfo = pemRd.readObject()) != null) {
            void var18_18;
            privKey = var18_18 instanceof PrivateKeyInfo ? (RSAPrivateCrtKey)converter.getPrivateKey(PrivateKeyInfo.getInstance((Object)var18_18)) : (RSAPrivateCrtKey)converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)var18_18).decryptPrivateKeyInfo(pkcs8Prov));
            if (privKey.getPublicExponent().equals(new BigInteger("10001", 16))) continue;
            this.fail("decryption of private key data check failed");
        }
    }

    private void keyPairTest(String name, KeyPair pair) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PEMWriter pWrt = new PEMWriter((Writer)new OutputStreamWriter(bOut));
        pWrt.writeObject((Object)pair.getPublic());
        pWrt.close();
        PEMParser pemRd = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance((Object)pemRd.readObject());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PublicKey k = converter.getPublicKey(pub);
        if (!k.equals(pair.getPublic())) {
            this.fail("Failed public key read: " + name);
        }
        bOut = new ByteArrayOutputStream();
        pWrt = new PEMWriter((Writer)new OutputStreamWriter(bOut));
        pWrt.writeObject((Object)pair.getPrivate());
        pWrt.close();
        pemRd = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(bOut.toByteArray())));
        KeyPair kPair = converter.getKeyPair((PEMKeyPair)pemRd.readObject());
        if (!kPair.getPrivate().equals(pair.getPrivate())) {
            this.fail("Failed private key read: " + name);
        }
        if (!kPair.getPublic().equals(pair.getPublic())) {
            this.fail("Failed private key public read: " + name);
        }
    }

    private void doOpenSslTests(String baseName) throws IOException {
        this.doOpenSslDsaModesTest(baseName);
        this.doOpenSslRsaModesTest(baseName);
    }

    private void doOpenSslDsaModesTest(String baseName) throws IOException {
        this.doOpenSslDsaTest(baseName + "_cbc");
        this.doOpenSslDsaTest(baseName + "_cfb");
        this.doOpenSslDsaTest(baseName + "_ecb");
        this.doOpenSslDsaTest(baseName + "_ofb");
    }

    private void doOpenSslRsaModesTest(String baseName) throws IOException {
        this.doOpenSslRsaTest(baseName + "_cbc");
        this.doOpenSslRsaTest(baseName + "_cfb");
        this.doOpenSslRsaTest(baseName + "_ecb");
        this.doOpenSslRsaTest(baseName + "_ofb");
    }

    private void doOpenSslDsaTest(String name) throws IOException {
        String fileName = "dsa/openssl_dsa_" + name + ".pem";
        this.doOpenSslTestFile(fileName, class$java$security$interfaces$DSAPrivateKey == null ? (class$java$security$interfaces$DSAPrivateKey = ParserTest.class$("java.security.interfaces.DSAPrivateKey")) : class$java$security$interfaces$DSAPrivateKey);
    }

    private void doOpenSslRsaTest(String name) throws IOException {
        String fileName = "rsa/openssl_rsa_" + name + ".pem";
        this.doOpenSslTestFile(fileName, class$java$security$interfaces$RSAPrivateKey == null ? (class$java$security$interfaces$RSAPrivateKey = ParserTest.class$("java.security.interfaces.RSAPrivateKey")) : class$java$security$interfaces$RSAPrivateKey);
    }

    private void doOpenSslTestFile(String fileName, Class expectedPrivKeyClass) throws IOException {
        KeyPair kp;
        PrivateKey privKey;
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build("changeit".toCharArray());
        PEMParser pr = this.openPEMResource("data/" + fileName);
        Object o = pr.readObject();
        if (o == null || !(o instanceof PEMKeyPair) && !(o instanceof PEMEncryptedKeyPair)) {
            this.fail("Didn't find OpenSSL key");
        }
        if (!expectedPrivKeyClass.isInstance(privKey = (kp = o instanceof PEMEncryptedKeyPair ? converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(decProv)) : converter.getKeyPair((PEMKeyPair)o)).getPrivate())) {
            this.fail("Returned key not of correct type");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doDudPasswordTest(String password, int index, String message) {
        try {
            Object o;
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build(password.toCharArray());
            PEMParser pemRd = this.openPEMResource("test.pem");
            while ((o = pemRd.readObject()) != null) {
                void var6_7;
                if (!(var6_7 instanceof PEMEncryptedKeyPair)) continue;
                ((PEMEncryptedKeyPair)var6_7).decryptKeyPair(decProv);
            }
            this.fail("issue not detected: " + index);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doNoPasswordTest() throws IOException {
        Object o;
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().setProvider("BC").build("".toCharArray());
        PEMParser pemRd = this.openPEMResource("smimenopw.pem");
        PrivateKeyInfo key = null;
        while ((o = pemRd.readObject()) != null) {
            void var3_4;
            key = (PrivateKeyInfo)var3_4;
        }
        if (key == null) {
            this.fail("private key not detected");
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new ParserTest());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Password
    implements PasswordFinder {
        char[] password;

        Password(char[] word) {
            this.password = word;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

