/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl.test;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jcajce.CompositePrivateKey;
import org.bouncycastle.jcajce.CompositePublicKey;
import org.bouncycastle.jcajce.spec.CompositeAlgorithmSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.Strings;

public class CompositeKeyTest
extends TestCase {
    private static final String genPubKey = "-----BEGIN PUBLIC KEY-----\nMIIBmDAMBgpghkgBhvprUAQBA4IBhgAwggGBMFkwEwYHKoZIzj0CAQYIKoZIzj0D\nAQcDQgAExGPhrnuSG/fGyw1FN+l5h4p4AGRQCS0LBXnBO+djhcI6qnF2TvrQEaIY\nGGpQT5wHS+7y5iJJ+dE5qjxcv8loRDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC\nAQoCggEBANsVQK1fcLQObL4ZYtczWbObECAFSsng0OLpRTPr9VGV3SsS/VoMRZqX\nF+sszz6I2UcFTaMF9CwNRbWLuIBczzuhbHSjn65OuoN+Om2wsPo+okw46RTekB4a\nd9QQvYRVzPlILUQ8NvZ4W0BKLviXTXWIggjtp/Y1pKRHKz8n35J6OmFWz4TKGNth\nn87D28kmdwQYH5NLsDePHbfdw3AyLrPvQLlQw/hRPz/9Txf7yi9Djg9HtJ88ES6+\nZbfE1ZHxLYLSDt25tSL8A2pMuGMD3P81nYWO+gJ0vYV2WcRpXHRkjmliGqiCg4eB\nmC4//tm0J4r9Ll8b/pp6xyOMI7jppVUCAwEAAQ==\n-----END PUBLIC KEY-----\n";
    private static final String genPrivKey = "-----BEGIN PRIVATE KEY-----\nMIIFHgIBADAMBgpghkgBhvprUAQBBIIFCTCCBQUwQQIBADATBgcqhkjOPQIBBggq\nhkjOPQMBBwQnMCUCAQEEICN0ihCcgg5n8ALtk9tkQZqg/WLEm5NefMi/kdN06Z9u\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDbFUCtX3C0Dmy+\nGWLXM1mzmxAgBUrJ4NDi6UUz6/VRld0rEv1aDEWalxfrLM8+iNlHBU2jBfQsDUW1\ni7iAXM87oWx0o5+uTrqDfjptsLD6PqJMOOkU3pAeGnfUEL2EVcz5SC1EPDb2eFtA\nSi74l011iIII7af2NaSkRys/J9+SejphVs+EyhjbYZ/Ow9vJJncEGB+TS7A3jx23\n3cNwMi6z70C5UMP4UT8//U8X+8ovQ44PR7SfPBEuvmW3xNWR8S2C0g7dubUi/ANq\nTLhjA9z/NZ2FjvoCdL2FdlnEaVx0ZI5pYhqogoOHgZguP/7ZtCeK/S5fG/6aescj\njCO46aVVAgMBAAECggEAFtT6LpdZuYofTxh6Mo9Jc+xfG9cxWiSx4FQLQEQBBwWl\nTQ3nlXDd+CRy+7Fpz8yXSE2HL8w5DDY945OyIL6LYl2KXgWHaLUPvxByqmfVqd7J\nL0RnFiOzxU9g2Zr9BUOj3v7kqM3VtI4KhIK2rnWmPu+BDckmzgP9Kpm4KhbPuAYP\niqUZSkxpSUsd5ALLsk9b0xjR7UEYkEpV2/vORwieEhOmPLzuXh+Px0yavkazT/vU\n+h/rDSoLQn7v4fVsQgNdOaaOG/gHemGuuiLPJJlX5ZZ6mmsIaEjz+MNk0aJDH2po\nKbAr4B709dTsnYgv7YtkEfSyOeMEdhMiswI1c9FpwQKBgQD6kdHmHCoeWNNvlqxU\nv57e7ZDAXDA6WcfrypcsF0l72rI3J8oOPmFaNaCmwIH/Icz+Zy7fr2IYxVjyDjCa\nzi8qTnj2ZNds71hUYOcq60u0TcSVrtocA4HW7NoWJqK5thNlNaa1M358cYBopGoN\nocS9yf10q2MBZtpF0fc5PbFf+QKBgQDf1L4cezoebbNTaN4KoapycHXxKozP2GwI\nr15YRYjt0ZpHstdUPABQuwlL9CuL+5Q17VRiM81cUVNfFsBzKIXYb/PBC5UD+DmR\nqGlT6v6uUWY6jifUgEjfyPxO0oJ3M6cChHR/TvpkT5SyaEwHpIH7IeXbMFcS5m4G\nmSNBECO/PQKBgCD0CoHT1Go3Tl9PloxywwcYgT/7H9CcvCEzfJws19o1EdkVH4qu\nA4mkoeMsUCxompgeo9iBLUqKsb7rxNKnKSbMOTZWXsqR07ENKXnIhiVJUQBKhZ7H\ni0zjy268WAxKeNSHsMwF4K2nE7cvYE84pjI7nVy5qYSmrTAfg/8AMRKpAoGBAN/G\nwN6WsE9Vm5BLapo0cMUC/FdFFAyEMdYpBei4dCJXiKgf+7miVypfI/dEwPitZ8rW\nYKPhaHHgeLq7c2JuZAo0Ov2IR831MBEYz1zvtvmuNcda8iU4sCLTvLRNL9Re1pzk\nsdfJrPn2uhH3xfNqG+1oQXZ3CMbDi8Ka/a0Bpst9AoGBAPR4p6WN0aoZlosyT6NI\n4mqzNvLE4KBasmfoMmTJih7qCP3X4pqdgiI0SjsQQG/+utHLoJARwzhWHOZf1JKk\nD8lSJH02cp/Znrjn5wPpfYKLphJBiKSPwyIjuFwcR1ck84ONeYq421NDqf7lXbvx\noMqjTPagXUpzHvwluDjtSi8+\n-----END PRIVATE KEY-----\n";
    private static final String expPubKey = "-----BEGIN PUBLIC KEY-----\nMIIBkTAFBgMqAwQDggGGADCCAYEwWTATBgcqhkjOPQIBBggqhkjOPQMBBwNCAATE\nY+Gue5Ib98bLDUU36XmHingAZFAJLQsFecE752OFwjqqcXZO+tARohgYalBPnAdL\n7vLmIkn50TmqPFy/yWhEMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\n2xVArV9wtA5svhli1zNZs5sQIAVKyeDQ4ulFM+v1UZXdKxL9WgxFmpcX6yzPPojZ\nRwVNowX0LA1FtYu4gFzPO6FsdKOfrk66g346bbCw+j6iTDjpFN6QHhp31BC9hFXM\n+UgtRDw29nhbQEou+JdNdYiCCO2n9jWkpEcrPyffkno6YVbPhMoY22GfzsPbySZ3\nBBgfk0uwN48dt93DcDIus+9AuVDD+FE/P/1PF/vKL0OOD0e0nzwRLr5lt8TVkfEt\ngtIO3bm1IvwDaky4YwPc/zWdhY76AnS9hXZZxGlcdGSOaWIaqIKDh4GYLj/+2bQn\niv0uXxv+mnrHI4wjuOmlVQIDAQAB\n-----END PUBLIC KEY-----\n";
    private static final String expPrivKey = "-----BEGIN PRIVATE KEY-----\nMIIFFwIBADAFBgMqAwQEggUJMIIFBTBBAgEAMBMGByqGSM49AgEGCCqGSM49AwEH\nBCcwJQIBAQQgI3SKEJyCDmfwAu2T22RBmqD9YsSbk158yL+R03Tpn24wggS+AgEA\nMA0GCSqGSIb3DQEBAQUABIIEqDCCBKQCAQACggEBANsVQK1fcLQObL4ZYtczWbOb\nECAFSsng0OLpRTPr9VGV3SsS/VoMRZqXF+sszz6I2UcFTaMF9CwNRbWLuIBczzuh\nbHSjn65OuoN+Om2wsPo+okw46RTekB4ad9QQvYRVzPlILUQ8NvZ4W0BKLviXTXWI\nggjtp/Y1pKRHKz8n35J6OmFWz4TKGNthn87D28kmdwQYH5NLsDePHbfdw3AyLrPv\nQLlQw/hRPz/9Txf7yi9Djg9HtJ88ES6+ZbfE1ZHxLYLSDt25tSL8A2pMuGMD3P81\nnYWO+gJ0vYV2WcRpXHRkjmliGqiCg4eBmC4//tm0J4r9Ll8b/pp6xyOMI7jppVUC\nAwEAAQKCAQAW1Poul1m5ih9PGHoyj0lz7F8b1zFaJLHgVAtARAEHBaVNDeeVcN34\nJHL7sWnPzJdITYcvzDkMNj3jk7IgvotiXYpeBYdotQ+/EHKqZ9Wp3skvRGcWI7PF\nT2DZmv0FQ6Pe/uSozdW0jgqEgraudaY+74ENySbOA/0qmbgqFs+4Bg+KpRlKTGlJ\nSx3kAsuyT1vTGNHtQRiQSlXb+85HCJ4SE6Y8vO5eH4/HTJq+RrNP+9T6H+sNKgtC\nfu/h9WxCA105po4b+Ad6Ya66Is8kmVfllnqaawhoSPP4w2TRokMfamgpsCvgHvT1\n1OydiC/ti2QR9LI54wR2EyKzAjVz0WnBAoGBAPqR0eYcKh5Y02+WrFS/nt7tkMBc\nMDpZx+vKlywXSXvasjcnyg4+YVo1oKbAgf8hzP5nLt+vYhjFWPIOMJrOLypOePZk\n12zvWFRg5yrrS7RNxJWu2hwDgdbs2hYmorm2E2U1prUzfnxxgGikag2hxL3J/XSr\nYwFm2kXR9zk9sV/5AoGBAN/Uvhx7Oh5ts1No3gqhqnJwdfEqjM/YbAivXlhFiO3R\nmkey11Q8AFC7CUv0K4v7lDXtVGIzzVxRU18WwHMohdhv88ELlQP4OZGoaVPq/q5R\nZjqOJ9SASN/I/E7SgnczpwKEdH9O+mRPlLJoTAekgfsh5dswVxLmbgaZI0EQI789\nAoGAIPQKgdPUajdOX0+WjHLDBxiBP/sf0Jy8ITN8nCzX2jUR2RUfiq4DiaSh4yxQ\nLGiamB6j2IEtSoqxvuvE0qcpJsw5NlZeypHTsQ0peciGJUlRAEqFnseLTOPLbrxY\nDEp41IewzAXgracTty9gTzimMjudXLmphKatMB+D/wAxEqkCgYEA38bA3pawT1Wb\nkEtqmjRwxQL8V0UUDIQx1ikF6Lh0IleIqB/7uaJXKl8j90TA+K1nytZgo+FoceB4\nurtzYm5kCjQ6/YhHzfUwERjPXO+2+a41x1ryJTiwItO8tE0v1F7WnOSx18ms+fa6\nEffF82ob7WhBdncIxsOLwpr9rQGmy30CgYEA9HinpY3RqhmWizJPo0jiarM28sTg\noFqyZ+gyZMmKHuoI/dfimp2CIjRKOxBAb/660cugkBHDOFYc5l/UkqQPyVIkfTZy\nn9meuOfnA+l9goumEkGIpI/DIiO4XBxHVyTzg415irjbU0Op/uVdu/GgyqNM9qBd\nSnMe/CW4OO1KLz4=\n-----END PRIVATE KEY-----\n";

    public void setUp() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void testGenericCompositeKey() throws Exception {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(genPubKey));
        SubjectPublicKeyInfo pubKey = (SubjectPublicKeyInfo)pemParser.readObject();
        pemParser = new PEMParser((Reader)new StringReader(genPrivKey));
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemParser.readObject();
    }

    public void testExplicitCompositeKey() throws Exception {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(expPubKey));
        SubjectPublicKeyInfo pubKey = (SubjectPublicKeyInfo)pemParser.readObject();
        pemParser = new PEMParser((Reader)new StringReader(genPrivKey));
        PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemParser.readObject();
    }

    public void testRSAAndECCompositeGen() throws Exception {
        KeyPairGenerator ecKpg = KeyPairGenerator.getInstance("EC", "BC");
        ecKpg.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair ecKp = ecKpg.generateKeyPair();
        PrivateKey ecPriv = ecKp.getPrivate();
        PublicKey ecPub = ecKp.getPublic();
        KeyPairGenerator rsaKpg = KeyPairGenerator.getInstance("RSA", "BC");
        rsaKpg.initialize(new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4));
        KeyPair lmsKp = rsaKpg.generateKeyPair();
        PrivateKey lmsPriv = lmsKp.getPrivate();
        PublicKey lmsPub = lmsKp.getPublic();
        CompositeAlgorithmSpec compAlgSpec = new CompositeAlgorithmSpec.Builder().add("SHA256withECDSA").add("SHA256withRSA").build();
        CompositePublicKey compPub = new CompositePublicKey(new PublicKey[]{ecPub, lmsPub});
        CompositePrivateKey compPrivKey = new CompositePrivateKey(new PrivateKey[]{ecPriv, lmsPriv});
        ContentSigner sigGen = new JcaContentSignerBuilder("Composite", (AlgorithmParameterSpec)compAlgSpec).build((PrivateKey)compPrivKey);
        X500Name issuerName = new X500Name("CN=Composite EC/RSA Test");
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(issuerName, BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), issuerName, (PublicKey)compPub);
        X509CertificateHolder ecCertHldr = certGen.build(sigGen);
        ContentVerifierProvider vProv = new JcaContentVerifierProviderBuilder().build((PublicKey)compPub);
        Assert.assertTrue((String)"ec multi failed", (boolean)ecCertHldr.isSignatureValid(vProv));
        vProv = new JcaContentVerifierProviderBuilder().build(ecPub);
        Assert.assertTrue((String)"ec failed", (boolean)ecCertHldr.isSignatureValid(vProv));
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(ecCertHldr);
        cert.checkValidity(new Date());
        cert.verify((PublicKey)compPub);
        cert.verify(ecPub);
        cert.verify(ecPub, "BC");
        cert.verify(cert.getPublicKey());
        ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getEncoded());
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        cert = (X509Certificate)fact.generateCertificate(bIn);
        Certificate crt = Certificate.getInstance((Object)cert.getEncoded());
        Assert.assertTrue((boolean)MiscObjectIdentifiers.id_composite_key.equals((ASN1Primitive)crt.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm()));
        Assert.assertTrue((null == crt.getSubjectPublicKeyInfo().getAlgorithm().getParameters() ? 1 : 0) != 0);
        KeyFactory kFact = KeyFactory.getInstance("Composite", "BC");
        CompositePublicKey pubKey = (CompositePublicKey)kFact.generatePublic(new X509EncodedKeySpec(compPub.getEncoded()));
        CompositePrivateKey privKey = (CompositePrivateKey)kFact.generatePrivate(new PKCS8EncodedKeySpec(compPrivKey.getEncoded()));
        Assert.assertTrue((boolean)pubKey.equals((Object)compPub));
        Assert.assertTrue((boolean)privKey.equals((Object)compPrivKey));
        StringWriter sWrt = new StringWriter();
        JcaPEMWriter pWrt = new JcaPEMWriter((Writer)sWrt);
        pWrt.writeObject((Object)cert);
        pWrt.close();
        String certKeyStr = sWrt.toString();
        sWrt = new StringWriter();
        pWrt = new JcaPEMWriter((Writer)sWrt);
        pWrt.writeObject((Object)privKey);
        pWrt.close();
        String privKeyStr = sWrt.toString();
        sWrt = new StringWriter();
        pWrt = new JcaPEMWriter((Writer)sWrt);
        pWrt.writeObject((Object)pubKey);
        pWrt.close();
        String pubKeyStr = sWrt.toString();
        PEMParser pemParser = new PEMParser((Reader)new StringReader(certKeyStr));
        X509CertificateHolder certHldr = (X509CertificateHolder)pemParser.readObject();
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])cert.getEncoded(), (byte[])certHldr.getEncoded()));
        pemParser = new PEMParser((Reader)new StringReader(privKeyStr));
        PrivateKeyInfo privInfo = (PrivateKeyInfo)pemParser.readObject();
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])privKey.getEncoded(), (byte[])privInfo.getEncoded()));
        pemParser = new PEMParser((Reader)new StringReader(pubKeyStr));
        SubjectPublicKeyInfo pubInfo = (SubjectPublicKeyInfo)pemParser.readObject();
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])pubKey.getEncoded(), (byte[])pubInfo.getEncoded()));
    }

    public void testRSAAndECCompositeSignedDataGen() throws Exception {
        KeyPairGenerator ecKpg = KeyPairGenerator.getInstance("EC", "BC");
        ecKpg.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair ecKp = ecKpg.generateKeyPair();
        PrivateKey ecPriv = ecKp.getPrivate();
        PublicKey ecPub = ecKp.getPublic();
        KeyPairGenerator rsaKpg = KeyPairGenerator.getInstance("RSA", "BC");
        rsaKpg.initialize(new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4));
        KeyPair lmsKp = rsaKpg.generateKeyPair();
        PrivateKey lmsPriv = lmsKp.getPrivate();
        PublicKey lmsPub = lmsKp.getPublic();
        CompositeAlgorithmSpec compAlgSpec = new CompositeAlgorithmSpec.Builder().add("SHA256withECDSA").add("SHA256withRSA").build();
        CompositePublicKey compPub = new CompositePublicKey(new PublicKey[]{ecPub, lmsPub});
        CompositePrivateKey compPrivKey = new CompositePrivateKey(new PrivateKey[]{ecPriv, lmsPriv});
        ContentSigner sigGen = new JcaContentSignerBuilder("Composite", (AlgorithmParameterSpec)compAlgSpec).build((PrivateKey)compPrivKey);
        X500Name issuerName = new X500Name("CN=Composite EC/RSA Test");
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(issuerName, BigInteger.valueOf(1L), new Date(System.currentTimeMillis() - 50000L), new Date(System.currentTimeMillis() + 50000L), issuerName, (PublicKey)compPub);
        X509CertificateHolder ecCertHldr = certGen.build(sigGen);
        ContentVerifierProvider vProv = new JcaContentVerifierProviderBuilder().build((PublicKey)compPub);
        Assert.assertTrue((String)"ec multi failed", (boolean)ecCertHldr.isSignatureValid(vProv));
        vProv = new JcaContentVerifierProviderBuilder().build(ecPub);
        Assert.assertTrue((String)"ec failed", (boolean)ecCertHldr.isSignatureValid(vProv));
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(ecCertHldr);
        cert.checkValidity(new Date());
        cert.verify((PublicKey)compPub);
        cert.verify(cert.getPublicKey());
        ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getEncoded());
        CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
        cert = (X509Certificate)fact.generateCertificate(bIn);
        Certificate crt = Certificate.getInstance((Object)cert.getEncoded());
        Assert.assertTrue((boolean)MiscObjectIdentifiers.id_composite_key.equals((ASN1Primitive)crt.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm()));
        Assert.assertTrue((null == crt.getSubjectPublicKeyInfo().getAlgorithm().getParameters() ? 1 : 0) != 0);
        byte[] data = "Hello World!".getBytes();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        certList.add(cert);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        DigestCalculatorProvider digProvider = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digProvider);
        signerInfoGeneratorBuilder.setContentDigest(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256));
        gen.addSignerInfoGenerator(signerInfoGeneratorBuilder.build(sigGen, cert));
        gen.addCertificates((Store)certs);
        CMSSignedData s = gen.generate((CMSTypedData)msg, true);
        s = new CMSSignedData(s.getEncoded());
        SignerInformationStore sigStore = s.getSignerInfos();
        Store certStore = s.getCertificates();
        SignerInformation sigInf = (SignerInformation)sigStore.getSigners().iterator().next();
        Assert.assertTrue((boolean)sigInf.verify(new JcaSimpleSignerInfoVerifierBuilder().build((X509CertificateHolder)certStore.getMatches(null).iterator().next())));
        StringWriter sWrt = new StringWriter();
        JcaPEMWriter pWrt = new JcaPEMWriter((Writer)sWrt);
        pWrt.writeObject((Object)s.toASN1Structure());
        pWrt.close();
        PEMParser parser = new PEMParser((Reader)new StringReader(sWrt.toString()));
        s = new CMSSignedData((ContentInfo)parser.readObject());
        sigStore = s.getSignerInfos();
        certStore = s.getCertificates();
        sigInf = (SignerInformation)sigStore.getSigners().iterator().next();
        Assert.assertTrue((boolean)sigInf.verify(new JcaSimpleSignerInfoVerifierBuilder().build((X509CertificateHolder)certStore.getMatches(null).iterator().next())));
    }

    private static void doOutput(String fileName, String contents) throws IOException {
        FileOutputStream fOut = new FileOutputStream(fileName);
        fOut.write(Strings.toByteArray((String)contents));
        fOut.close();
    }
}

