/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mozilla.test;

import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.mozilla.PublicKeyAndChallenge;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mozilla.jcajce.JcaSignedPublicKeyAndChallenge;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class SPKACTest
extends SimpleTest {
    byte[] spkac = Base64.decode((String)"MIIBOjCBpDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApne7ti0ibPhV8Iht7Pws5iRckM7x4mtZYxEpeX5/IO8tDsBFdY86ewuY2f2KCca0oMWr43kdkZbPyzf4CSV+0fZm9MJyNMywygZjoOCC+rS8kr0Ef31iHChhYsyejJnjw116Jnn96syhdHY6lVD1rK0nn5ZkHjxU74gjoZu6BJMCAwEAARYAMA0GCSqGSIb3DQEBBAUAA4GBAKFLg/luv0C7gMTI8ZKfFoSyi7Q7kiSQcmSj1WJgT56ouIRJO5NdvB/1n4GNik8VOAU0NRztvGy3ZGqgbSav7lrxcNEvXH+dLbtS97s7yiaozpsOcEHqsBribpLOTRzYa8ciCwkPmIiYqcby11diKLpd+W9RFYNme2v0rrbM2CyV");

    public String getName() {
        return "SignedPubicKeyAndChallenge";
    }

    public void spkacTest(String testName, byte[] req) throws Exception {
        byte[] bytes;
        ASN1IA5String challenge;
        SubjectPublicKeyInfo spki;
        JcaSignedPublicKeyAndChallenge spkac = new JcaSignedPublicKeyAndChallenge(req).setProvider("BC");
        PublicKeyAndChallenge pkac = spkac.getPublicKeyAndChallenge();
        PublicKey pubKey = spkac.getPublicKey();
        ASN1Primitive obj = pkac.toASN1Primitive();
        if (obj == null) {
            this.fail("Error - " + testName + " PKAC ASN1Primitive was null.");
        }
        if ((obj = spkac.toASN1Structure().toASN1Primitive()) == null) {
            this.fail("Error - " + testName + " SPKAC ASN1Primitive was null.");
        }
        if ((spki = pkac.getSubjectPublicKeyInfo()) == null) {
            this.fail("Error - " + testName + " SubjectPublicKeyInfo was null.");
        }
        if ((challenge = pkac.getChallengeIA5()) == null) {
            this.fail("Error - " + testName + " challenge was null.");
        }
        if ((bytes = spkac.toASN1Structure().getEncoded("DER")).length != req.length) {
            this.fail(testName + " failed length test");
        }
        int i = 0;
        while (i != req.length) {
            if (bytes[i] != req[i]) {
                this.fail(testName + " failed comparison test");
            }
            ++i;
        }
        if (!spkac.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(pubKey))) {
            this.fail(testName + " verification failed");
        }
    }

    public void spkacNewTest(String testName, byte[] req) throws Exception {
        byte[] bytes;
        ASN1IA5String challenge;
        SubjectPublicKeyInfo spki;
        JcaSignedPublicKeyAndChallenge spkac = new JcaSignedPublicKeyAndChallenge(req);
        PublicKeyAndChallenge pkac = spkac.getPublicKeyAndChallenge();
        PublicKey pubKey = spkac.getPublicKey();
        ASN1Primitive obj = pkac.toASN1Primitive();
        if (obj == null) {
            this.fail("Error - " + testName + " PKAC ASN1Primitive was null.");
        }
        if ((obj = spkac.toASN1Structure().toASN1Primitive()) == null) {
            this.fail("Error - " + testName + " SPKAC ASN1Primitive was null.");
        }
        if ((spki = pkac.getSubjectPublicKeyInfo()) == null) {
            this.fail("Error - " + testName + " SubjectPublicKeyInfo was null.");
        }
        if ((challenge = pkac.getChallengeIA5()) == null) {
            this.fail("Error - " + testName + " challenge was null.");
        }
        if ((bytes = spkac.toASN1Structure().getEncoded("DER")).length != req.length) {
            this.fail(testName + " failed length test");
        }
        int i = 0;
        while (i != req.length) {
            if (bytes[i] != req[i]) {
                this.fail(testName + " failed comparison test");
            }
            ++i;
        }
        if (!spkac.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(spkac.getSubjectPublicKeyInfo()))) {
            this.fail(testName + " verification failed");
        }
        JcaSignedPublicKeyAndChallenge jcaSignedPublicKeyAndChallenge = new JcaSignedPublicKeyAndChallenge(req);
        if (!spkac.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(jcaSignedPublicKeyAndChallenge.getPublicKey()))) {
            this.fail(testName + " verification failed");
        }
    }

    public void performTest() throws Exception {
        this.spkacTest("spkac", this.spkac);
        this.spkacNewTest("spkac", this.spkac);
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new SPKACTest());
    }
}

