/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.math.Primes;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class PrimesTest
extends TestCase {
    private static final int ITERATIONS = 10;
    private static final int PRIME_BITS = 256;
    private static final int PRIME_CERTAINTY = 100;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final SecureRandom R = new SecureRandom();
    static /* synthetic */ Class class$org$bouncycastle$math$test$PrimesTest;

    public void testHasAnySmallFactors() {
        int iterations = 0;
        while (iterations < 10) {
            BigInteger prime = PrimesTest.randomPrime();
            Assert.assertFalse((boolean)Primes.hasAnySmallFactors((BigInteger)prime));
            int smallFactor = 2;
            while (smallFactor <= 211) {
                BigInteger nonPrimeWithSmallFactor = BigInteger.valueOf(smallFactor).multiply(prime);
                Assert.assertTrue((boolean)Primes.hasAnySmallFactors((BigInteger)nonPrimeWithSmallFactor));
                ++smallFactor;
            }
            ++iterations;
        }
    }

    public void testEnhancedMRProbablePrime() {
        int mrIterations = 50;
        int iterations = 0;
        while (iterations < 10) {
            BigInteger prime = PrimesTest.randomPrime();
            Primes.MROutput mr = Primes.enhancedMRProbablePrimeTest((BigInteger)prime, (SecureRandom)R, (int)mrIterations);
            Assert.assertFalse((boolean)mr.isProvablyComposite());
            Assert.assertFalse((boolean)mr.isNotPrimePower());
            Assert.assertNull((Object)mr.getFactor());
            BigInteger primePower = prime;
            int i = 0;
            while (i <= iterations % 8) {
                primePower = primePower.multiply(prime);
                ++i;
            }
            Primes.MROutput mr2 = Primes.enhancedMRProbablePrimeTest((BigInteger)primePower, (SecureRandom)R, (int)mrIterations);
            Assert.assertTrue((boolean)mr2.isProvablyComposite());
            Assert.assertFalse((boolean)mr2.isNotPrimePower());
            Assert.assertEquals((Object)mr2.getFactor(), (Object)prime);
            BigInteger nonPrimePower = PrimesTest.randomPrime().multiply(prime);
            Primes.MROutput mr3 = Primes.enhancedMRProbablePrimeTest((BigInteger)nonPrimePower, (SecureRandom)R, (int)mrIterations);
            Assert.assertTrue((boolean)mr3.isProvablyComposite());
            Assert.assertTrue((boolean)mr3.isNotPrimePower());
            Assert.assertNull((Object)mr.getFactor());
            ++iterations;
        }
    }

    public void testMRProbablePrime() {
        int mrIterations = 50;
        int iterations = 0;
        while (iterations < 10) {
            BigInteger prime = PrimesTest.randomPrime();
            Assert.assertTrue((boolean)Primes.isMRProbablePrime((BigInteger)prime, (SecureRandom)R, (int)mrIterations));
            BigInteger nonPrime = PrimesTest.randomPrime().multiply(prime);
            Assert.assertFalse((boolean)Primes.isMRProbablePrime((BigInteger)nonPrime, (SecureRandom)R, (int)mrIterations));
            ++iterations;
        }
    }

    public void testMRProbablePrimeToBase() {
        int mrIterations = 50;
        int iterations = 0;
        while (iterations < 10) {
            BigInteger prime = PrimesTest.randomPrime();
            Assert.assertTrue((boolean)PrimesTest.referenceIsMRProbablePrime(prime, mrIterations));
            BigInteger nonPrime = PrimesTest.randomPrime().multiply(prime);
            Assert.assertFalse((boolean)PrimesTest.referenceIsMRProbablePrime(nonPrime, mrIterations));
            ++iterations;
        }
    }

    public void testSTRandomPrime() {
        Digest[] digests = new Digest[]{new SHA1Digest(), new SHA256Digest()};
        int digestIndex = 0;
        while (digestIndex < digests.length) {
            int coincidenceCount = 0;
            Digest digest = digests[digestIndex];
            int iterations = 0;
            while (iterations < 10) {
                try {
                    byte[] inputSeed = new byte[16];
                    R.nextBytes(inputSeed);
                    Primes.STOutput st = Primes.generateSTRandomPrime((Digest)digest, (int)256, (byte[])inputSeed);
                    Assert.assertTrue((boolean)PrimesTest.isPrime(st.getPrime()));
                    Primes.STOutput st2 = Primes.generateSTRandomPrime((Digest)digest, (int)256, (byte[])inputSeed);
                    Assert.assertEquals((Object)st.getPrime(), (Object)st2.getPrime());
                    Assert.assertEquals((int)st.getPrimeGenCounter(), (int)st2.getPrimeGenCounter());
                    Assert.assertTrue((boolean)Arrays.areEqual((byte[])st.getPrimeSeed(), (byte[])st2.getPrimeSeed()));
                    int i = 0;
                    while (i < inputSeed.length) {
                        int n = i++;
                        inputSeed[n] = (byte)(inputSeed[n] ^ 0xFF);
                    }
                    Primes.STOutput st3 = Primes.generateSTRandomPrime((Digest)digest, (int)256, (byte[])inputSeed);
                    Assert.assertTrue((!st.getPrime().equals(st3.getPrime()) ? 1 : 0) != 0);
                    Assert.assertFalse((boolean)Arrays.areEqual((byte[])st.getPrimeSeed(), (byte[])st3.getPrimeSeed()));
                    if (st.getPrimeGenCounter() == st3.getPrimeGenCounter()) {
                        ++coincidenceCount;
                    }
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().startsWith("Too many iterations")) {
                        --iterations;
                    }
                    throw e;
                }
                ++iterations;
            }
            Assert.assertTrue((coincidenceCount * coincidenceCount < 10 ? 1 : 0) != 0);
            ++digestIndex;
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$math$test$PrimesTest == null ? (class$org$bouncycastle$math$test$PrimesTest = PrimesTest.class$("org.bouncycastle.math.test.PrimesTest")) : class$org$bouncycastle$math$test$PrimesTest);
    }

    private static boolean referenceIsMRProbablePrime(BigInteger x, int numBases) {
        BigInteger xSubTwo = x.subtract(TWO);
        int i = 0;
        while (i < numBases) {
            BigInteger b = BigIntegers.createRandomInRange((BigInteger)TWO, (BigInteger)xSubTwo, (SecureRandom)R);
            if (!Primes.isMRProbablePrimeToBase((BigInteger)x, (BigInteger)b)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isPrime(BigInteger x) {
        return x.isProbablePrime(100);
    }

    private static BigInteger randomPrime() {
        return BigIntegers.createRandomPrime((int)256, (int)100, (SecureRandom)R);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

