/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw.test;

import java.security.SecureRandom;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.math.raw.Interleave;

public class InterleaveTest
extends TestCase {
    private static final int ITERATIONS = 1000;
    private static final SecureRandom R = new SecureRandom();
    static /* synthetic */ Class class$org$bouncycastle$math$raw$test$InterleaveTest;

    public void testExpand8To16() {
        int iteration = 0;
        while (iteration < 256) {
            int x = iteration | R.nextInt() << 8;
            int expected = (int)InterleaveTest.referenceShuffle((long)x & 0xFFL);
            int actual = Interleave.expand8to16((int)x);
            Assert.assertEquals((int)expected, (int)actual);
            ++iteration;
        }
    }

    public void testExpand16To32() {
        int iteration = 0;
        while (iteration < 1000) {
            int x = R.nextInt();
            int expected = (int)InterleaveTest.referenceShuffle((long)x & 0xFFFFL);
            int actual = Interleave.expand16to32((int)x);
            Assert.assertEquals((int)expected, (int)actual);
            ++iteration;
        }
    }

    public void testExpand32To64() {
        int iteration = 0;
        while (iteration < 1000) {
            int x = R.nextInt();
            long expected = InterleaveTest.referenceShuffle((long)x & 0xFFFFFFFFL);
            long actual = Interleave.expand32to64((int)x);
            Assert.assertEquals((long)expected, (long)actual);
            ++iteration;
        }
    }

    public void testExpand64To128() {
        int iteration = 0;
        while (iteration < 1000) {
            long x = R.nextLong();
            long expected = InterleaveTest.referenceShuffle(x);
            long[] actual = new long[9];
            int offset = iteration % 8;
            actual[offset] = R.nextLong();
            actual[offset + 1] = R.nextLong();
            Interleave.expand64To128((long)x, (long[])actual, (int)offset);
            Assert.assertEquals((long)(expected & 0x5555555555555555L), (long)actual[offset]);
            Assert.assertEquals((long)(expected >>> 1 & 0x5555555555555555L), (long)actual[offset + 1]);
            ++iteration;
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$math$raw$test$InterleaveTest == null ? (class$org$bouncycastle$math$raw$test$InterleaveTest = InterleaveTest.class$("org.bouncycastle.math.raw.test.InterleaveTest")) : class$org$bouncycastle$math$raw$test$InterleaveTest);
    }

    private static long referenceShuffle(long x) {
        long result = 0L;
        long y = x >>> 32;
        int bit = 0;
        while (bit < 32) {
            long selector = 1L << bit;
            result |= (x & selector) << bit;
            result |= (y & selector) << bit + 1;
            ++bit;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

