/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;

public class FixedPointTest
extends TestCase {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int TESTS_PER_CURVE = 5;
    static /* synthetic */ Class class$org$bouncycastle$math$ec$test$FixedPointTest;

    public void testFixedPointMultiplier() {
        FixedPointCombMultiplier M = new FixedPointCombMultiplier();
        HashSet names = new HashSet(this.enumToList(ECNamedCurveTable.getNames()));
        names.addAll(this.enumToList(CustomNamedCurves.getNames()));
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            X9ECParameters x9A = ECNamedCurveTable.getByName((String)name);
            X9ECParameters x9B = CustomNamedCurves.getByName((String)name);
            X9ECParameters x9 = x9B != null ? x9B : x9A;
            int i = 0;
            while (i < 5) {
                BigInteger k = new BigInteger(x9.getN().bitLength(), RANDOM);
                ECPoint pRef = ECAlgorithms.referenceMultiply((ECPoint)x9.getG(), (BigInteger)k);
                if (x9A != null) {
                    ECPoint pA = M.multiply(x9A.getG(), k);
                    this.assertPointsEqual("Standard curve fixed-point failure", pRef, pA);
                }
                if (x9B != null) {
                    ECPoint pB = M.multiply(x9B.getG(), k);
                    this.assertPointsEqual("Custom curve fixed-point failure", pRef, pB);
                }
                ++i;
            }
        }
    }

    private List enumToList(Enumeration en) {
        ArrayList rv = new ArrayList();
        while (en.hasMoreElements()) {
            rv.add(en.nextElement());
        }
        return rv;
    }

    private void assertPointsEqual(String message, ECPoint a, ECPoint b) {
        Assert.assertEquals((String)message, (Object)a, (Object)b);
        Assert.assertEquals((String)message, (Object)b, (Object)a);
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$math$ec$test$FixedPointTest == null ? (class$org$bouncycastle$math$ec$test$FixedPointTest = FixedPointTest.class$("org.bouncycastle.math.ec.test.FixedPointTest")) : class$org$bouncycastle$math$ec$test$FixedPointTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

