/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.encoders.Hex;

public class ECPointTest
extends TestCase {
    private SecureRandom secRand = new SecureRandom();
    private Fp fp = null;
    private F2m f2m = null;
    static /* synthetic */ Class class$org$bouncycastle$math$ec$test$ECPointTest;

    public void setUp() {
        this.fp = new Fp();
        this.fp.createPoints();
        this.f2m = new F2m();
        this.f2m.createPoints();
    }

    public void testPointCreationConsistency() {
        ECPoint bad;
        try {
            bad = this.fp.curve.createPoint(new BigInteger("12"), null);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bad = this.fp.curve.createPoint(null, new BigInteger("12"));
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bad = this.f2m.curve.createPoint(new BigInteger("1011"), null);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bad = this.f2m.curve.createPoint(null, new BigInteger("1011"));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void implTestAdd(ECPoint[] p, ECPoint infinity) {
        this.assertPointsEqual("p0 plus p1 does not equal p2", p[2], p[0].add(p[1]));
        this.assertPointsEqual("p1 plus p0 does not equal p2", p[2], p[1].add(p[0]));
        int i = 0;
        while (i < p.length) {
            this.assertPointsEqual("Adding infinity failed", p[i], p[i].add(infinity));
            this.assertPointsEqual("Adding to infinity failed", p[i], infinity.add(p[i]));
            ++i;
        }
    }

    public void testLargeMInF2m() {
        int m = 2048;
        int k1 = 1;
        BigInteger aTpb = new BigInteger("1000", 2);
        BigInteger bTpb = new BigInteger("1001", 2);
        BigInteger n = new BigInteger("23");
        BigInteger h = new BigInteger("1");
        try {
            ECCurve.F2m curve = new ECCurve.F2m(m, k1, aTpb, bTpb, n, h);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"field size out of range: 2048", (String)e.getMessage());
        }
    }

    public void testAdd() {
        this.implTestAdd(this.fp.p, this.fp.infinity);
        this.implTestAdd(this.f2m.p, (ECPoint)this.f2m.infinity);
    }

    private void implTestTwice(ECPoint[] p) {
        this.assertPointsEqual("Twice incorrect", p[3], p[0].twice());
        this.assertPointsEqual("Add same point incorrect", p[3], p[0].add(p[0]));
    }

    public void testTwice() {
        this.implTestTwice(this.fp.p);
        this.implTestTwice(this.f2m.p);
    }

    private void implTestThreeTimes(ECPoint[] p) {
        ECPoint P = p[0];
        ECPoint _3P = P.add(P).add(P);
        this.assertPointsEqual("ThreeTimes incorrect", _3P, P.threeTimes());
        this.assertPointsEqual("TwicePlus incorrect", _3P, P.twicePlus(P));
    }

    public void testThreeTimes() {
        this.implTestThreeTimes(this.fp.p);
        this.implTestThreeTimes(this.f2m.p);
    }

    private void implTestAllPoints(ECPoint p, ECPoint infinity) {
        ECPoint adder = infinity;
        ECPoint multiplier = infinity;
        BigInteger i = BigInteger.valueOf(1L);
        do {
            adder = adder.add(p);
            multiplier = p.multiply(i);
            this.assertPointsEqual("Results of add() and multiply() are inconsistent " + i, adder, multiplier);
            i = i.add(BigInteger.ONE);
        } while (!adder.equals(infinity));
    }

    public void testAllPoints() {
        int i = 0;
        while (i < this.fp.p.length) {
            this.implTestAllPoints(this.fp.p[i], this.fp.infinity);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.f2m.p.length) {
            this.implTestAllPoints(this.f2m.p[i2], (ECPoint)this.f2m.infinity);
            ++i2;
        }
    }

    private void implTestMultiply(ECPoint p, int numBits) {
        BigInteger k = new BigInteger(numBits, this.secRand);
        ECPoint ref = ECAlgorithms.referenceMultiply((ECPoint)p, (BigInteger)k);
        ECPoint q = p.multiply(k);
        this.assertPointsEqual("ECPoint.multiply is incorrect", ref, q);
    }

    private void implTestMultiplyAll(ECPoint p, int numBits) {
        BigInteger bound = BigInteger.ONE.shiftLeft(numBits);
        BigInteger k = BigInteger.ZERO;
        do {
            ECPoint ref = ECAlgorithms.referenceMultiply((ECPoint)p, (BigInteger)k);
            ECPoint q = p.multiply(k);
            this.assertPointsEqual("ECPoint.multiply is incorrect", ref, q);
        } while ((k = k.add(BigInteger.ONE)).compareTo(bound) < 0);
    }

    private void implTestAddSubtract(ECPoint p, ECPoint infinity) {
        this.assertPointsEqual("Twice and Add inconsistent", p.twice(), p.add(p));
        this.assertPointsEqual("Twice p - p is not p", p, p.twice().subtract(p));
        this.assertPointsEqual("TwicePlus(p, -p) is not p", p, p.twicePlus(p.negate()));
        this.assertPointsEqual("p - p is not infinity", infinity, p.subtract(p));
        this.assertPointsEqual("p plus infinity is not p", p, p.add(infinity));
        this.assertPointsEqual("infinity plus p is not p", p, infinity.add(p));
        this.assertPointsEqual("infinity plus infinity is not infinity ", infinity, infinity.add(infinity));
        this.assertPointsEqual("Twice infinity is not infinity ", infinity, infinity.twice());
    }

    public void testAddSubtractMultiplySimple() {
        int fpBits = this.fp.curve.getOrder().bitLength();
        int iFp = 0;
        while (iFp < this.fp.pointSource.length / 2) {
            this.implTestAddSubtract(this.fp.p[iFp], this.fp.infinity);
            this.implTestMultiplyAll(this.fp.p[iFp], fpBits);
            this.implTestMultiplyAll(this.fp.infinity, fpBits);
            ++iFp;
        }
        int f2mBits = this.f2m.curve.getOrder().bitLength();
        int iF2m = 0;
        while (iF2m < this.f2m.pointSource.length / 2) {
            this.implTestAddSubtract(this.f2m.p[iF2m], (ECPoint)this.f2m.infinity);
            this.implTestMultiplyAll(this.f2m.p[iF2m], f2mBits);
            this.implTestMultiplyAll((ECPoint)this.f2m.infinity, f2mBits);
            ++iF2m;
        }
    }

    private void implTestEncoding(ECPoint p) {
        byte[] unCompBarr = p.getEncoded(false);
        ECPoint decUnComp = p.getCurve().decodePoint(unCompBarr);
        this.assertPointsEqual("Error decoding uncompressed point", p, decUnComp);
        byte[] compBarr = p.getEncoded(true);
        ECPoint decComp = p.getCurve().decodePoint(compBarr);
        this.assertPointsEqual("Error decoding compressed point", p, decComp);
    }

    private void implAddSubtractMultiplyTwiceEncodingTest(ECCurve curve, ECPoint q, BigInteger n) {
        ECPoint infinity = curve.getInfinity();
        this.implTestAddSubtract(q, infinity);
        this.implTestMultiply(q, n.bitLength());
        this.implTestMultiply(infinity, n.bitLength());
        int logSize = 32 - Integers.numberOfLeadingZeros((int)(curve.getFieldSize() - 1));
        int rounds = Math.max(2, Math.min(10, 32 - 3 * logSize));
        ECPoint p = q;
        int i = 0;
        while (i < rounds) {
            this.implTestEncoding(p);
            p = p.twice();
            ++i;
        }
    }

    private void implSqrtTest(ECCurve c) {
        block5: {
            block4: {
                if (!ECAlgorithms.isFpCurve((ECCurve)c)) break block4;
                BigInteger p = c.getField().getCharacteristic();
                BigInteger pMinusOne = p.subtract(ECConstants.ONE);
                BigInteger legendreExponent = p.shiftRight(1);
                ECFieldElement zero = c.fromBigInteger(BigInteger.ZERO);
                Assert.assertEquals((Object)zero, (Object)zero.sqrt());
                ECFieldElement one = c.fromBigInteger(BigInteger.ONE);
                Assert.assertEquals((Object)one, (Object)one.sqrt());
                int i = 0;
                while (i < 20) {
                    BigInteger x = BigIntegers.createRandomInRange((BigInteger)ECConstants.TWO, (BigInteger)pMinusOne, (SecureRandom)this.secRand);
                    ECFieldElement fe = c.fromBigInteger(x);
                    ECFieldElement root = fe.sqrt();
                    if (root == null) {
                        Assert.assertEquals((Object)pMinusOne, (Object)x.modPow(legendreExponent, p));
                    } else {
                        Assert.assertEquals((Object)fe, (Object)root.square());
                    }
                    ++i;
                }
                break block5;
            }
            if (!ECAlgorithms.isF2mCurve((ECCurve)c)) break block5;
            int m = c.getFieldSize();
            BigInteger x = new BigInteger(m, this.secRand);
            ECFieldElement fe = c.fromBigInteger(x);
            int i = 0;
            while (i < 100) {
                ECFieldElement sq = fe.square();
                ECFieldElement check = sq.sqrt();
                Assert.assertEquals((Object)fe, (Object)check);
                fe = sq;
                ++i;
            }
        }
    }

    private void implValidityTest(ECCurve c, ECPoint g) {
        BigInteger h;
        Assert.assertTrue((boolean)g.isValid());
        if (ECAlgorithms.isF2mCurve((ECCurve)c) && null != (h = c.getCofactor()) && !h.testBit(0)) {
            ECFieldElement sqrtB = c.getB().sqrt();
            ECPoint order2 = c.createPoint(ECConstants.ZERO, sqrtB.toBigInteger());
            Assert.assertTrue((boolean)order2.twice().isInfinity());
            Assert.assertFalse((boolean)order2.isValid());
            ECPoint bad2 = g.add(order2);
            Assert.assertFalse((boolean)bad2.isValid());
            ECPoint good2 = bad2.add(order2);
            Assert.assertTrue((boolean)good2.isValid());
            if (!h.testBit(1)) {
                ECFieldElement L = ECPointTest.solveQuadraticEquation(c, c.getA());
                Assert.assertNotNull((Object)L);
                ECFieldElement T = sqrtB;
                ECFieldElement x = T.sqrt();
                ECFieldElement y = T.add(x.multiply(L));
                ECPoint order4 = c.createPoint(x.toBigInteger(), y.toBigInteger());
                Assert.assertTrue((boolean)order4.twice().equals(order2));
                Assert.assertFalse((boolean)order4.isValid());
                ECPoint bad4_1 = g.add(order4);
                Assert.assertFalse((boolean)bad4_1.isValid());
                ECPoint bad4_2 = bad4_1.add(order4);
                Assert.assertFalse((boolean)bad4_2.isValid());
                ECPoint bad4_3 = bad4_2.add(order4);
                Assert.assertFalse((boolean)bad4_3.isValid());
                ECPoint good4 = bad4_3.add(order4);
                Assert.assertTrue((boolean)good4.isValid());
            }
        }
    }

    private void implAddSubtractMultiplyTwiceEncodingTestAllCoords(X9ECParameters x9ECParameters) {
        BigInteger n = x9ECParameters.getN();
        ECPoint G = x9ECParameters.getG();
        ECCurve C = x9ECParameters.getCurve();
        int[] coords = ECCurve.getAllCoordinateSystems();
        int i = 0;
        while (i < coords.length) {
            int coord = coords[i];
            if (C.supportsCoordinateSystem(coord)) {
                ECCurve c = C;
                ECPoint g = G;
                if (c.getCoordinateSystem() != coord) {
                    c = C.configure().setCoordinateSystem(coord).create();
                    g = c.importPoint(G);
                }
                BigInteger b = new BigInteger(n.bitLength(), this.secRand);
                ECPoint q = g.multiply(b).normalize();
                this.implAddSubtractMultiplyTwiceEncodingTest(c, q, n);
                this.implSqrtTest(c);
                this.implValidityTest(c, g);
            }
            ++i;
        }
    }

    public void testAddSubtractMultiplyTwiceEncoding() {
        HashSet names = new HashSet(this.enumToList(ECNamedCurveTable.getNames()));
        names.addAll(this.enumToList(CustomNamedCurves.getNames()));
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            X9ECParameters x9A = ECNamedCurveTable.getByName((String)name);
            X9ECParameters x9B = CustomNamedCurves.getByName((String)name);
            if (x9A != null && x9B != null) {
                Assert.assertEquals((Object)x9A.getCurve().getField(), (Object)x9B.getCurve().getField());
                Assert.assertEquals((Object)x9A.getCurve().getA().toBigInteger(), (Object)x9B.getCurve().getA().toBigInteger());
                Assert.assertEquals((Object)x9A.getCurve().getB().toBigInteger(), (Object)x9B.getCurve().getB().toBigInteger());
                this.assertOptionalValuesAgree(x9A.getCurve().getCofactor(), x9B.getCurve().getCofactor());
                this.assertOptionalValuesAgree(x9A.getCurve().getOrder(), x9B.getCurve().getOrder());
                this.assertPointsEqual("Custom curve base-point inconsistency", x9A.getG(), x9B.getG());
                Assert.assertEquals((Object)x9A.getH(), (Object)x9B.getH());
                Assert.assertEquals((Object)x9A.getN(), (Object)x9B.getN());
                this.assertOptionalValuesAgree(x9A.getSeed(), x9B.getSeed());
                BigInteger k = new BigInteger(x9A.getN().bitLength(), this.secRand);
                ECPoint pA = x9A.getG().multiply(k);
                ECPoint pB = x9B.getG().multiply(k);
                this.assertPointsEqual("Custom curve multiplication inconsistency", pA, pB);
            }
            if (x9A != null) {
                this.implAddSubtractMultiplyTwiceEncodingTestAllCoords(x9A);
            }
            if (x9B == null) continue;
            this.implAddSubtractMultiplyTwiceEncodingTestAllCoords(x9B);
        }
    }

    public void testExampleFpB0() throws Exception {
        BigInteger p = ECPointTest.fromHex("997ABB1F0A563FDA65C61198DAD0657A416C0CE19CB48261BE9AE358B3E01A2EF40AAB27E2FC0F1B228730D531A59CB0E791B39FF7C88A19356D27F4A666A6D0E26C6487326B4CD4512AC5CD65681CE1B6AFF4A831852A82A7CF3C521C3C09AA9F94D6AF56971F1FFCE3E82389857DB080C5DF10AC7ACE87666D807AFEA85FEB");
        BigInteger a = p.subtract(BigInteger.valueOf(3L));
        BigInteger b = BigInteger.valueOf(0L);
        byte[] S = null;
        BigInteger n = p.add(BigInteger.valueOf(1L)).shiftRight(2);
        BigInteger h = BigInteger.valueOf(4L);
        ECCurve curve = ECPointTest.configureCurve((ECCurve)new ECCurve.Fp(p, a, b, n, h));
        X9ECPoint G = ECPointTest.configureBasepoint(curve, "0453FC09EE332C29AD0A7990053ED9B52A2B1A2FD60AEC69C698B2F204B6FF7CBFB5EDB6C0F6CE2308AB10DB9030B09E1043D5F22CDB9DFA55718BD9E7406CE8909760AF765DD5BCCB337C86548B72F2E1A702C3397A60DE74A7C1514DBA66910DD5CFB4CC80728D87EE9163A5B63F73EC80EC46C4967E0979880DC8ABEAE638950A8249063F6009F1F9F1F0533634A135D3E82016029906963D778D821E141178F5EA69F4654EC2B9E7F7F5E5F0DE55F66B598CCF9A140B2E416CFF0CA9E032B970DAE117AD547C6CCAD696B5B7652FE0AC6F1E80164AA989492D979FC5A4D5F213515AD7E9CB99A980BDAD5AD5BB4636ADB9B5706A67DCDE75573FD71BEF16D7");
        X9ECParameters x9 = new X9ECParameters(curve, G, n, h, S);
        this.implAddSubtractMultiplyTwiceEncodingTestAllCoords(x9);
    }

    private void assertPointsEqual(String message, ECPoint a, ECPoint b) {
        Assert.assertEquals((String)message, (Object)a, (Object)b);
        Assert.assertEquals((String)message, (Object)b, (Object)a);
    }

    private void assertOptionalValuesAgree(Object a, Object b) {
        if (a != null && b != null) {
            Assert.assertEquals((Object)a, (Object)b);
        }
    }

    private void assertOptionalValuesAgree(byte[] a, byte[] b) {
        if (a != null && b != null) {
            Assert.assertTrue((boolean)Arrays.areEqual((byte[])a, (byte[])b));
        }
    }

    private static X9ECPoint configureBasepoint(ECCurve curve, String encoding) {
        X9ECPoint G = new X9ECPoint(curve, Hex.decode((String)encoding));
        WNafUtil.configureBasepoint((ECPoint)G.getPoint());
        return G;
    }

    private static ECCurve configureCurve(ECCurve curve) {
        return curve;
    }

    private List enumToList(Enumeration en) {
        ArrayList rv = new ArrayList();
        while (en.hasMoreElements()) {
            rv.add(en.nextElement());
        }
        return rv;
    }

    private static BigInteger fromHex(String hex) {
        return new BigInteger(1, Hex.decode((String)hex));
    }

    private static ECFieldElement solveQuadraticEquation(ECCurve c, ECFieldElement rhs) {
        ECFieldElement z;
        ECFieldElement gamma;
        if (rhs.isZero()) {
            return rhs;
        }
        ECFieldElement zeroElement = c.fromBigInteger(ECConstants.ZERO);
        int m = c.getFieldSize();
        Random rand = new Random();
        do {
            ECFieldElement t = c.fromBigInteger(new BigInteger(m, rand));
            z = zeroElement;
            ECFieldElement w = rhs;
            int i = 1;
            while (i < m) {
                ECFieldElement w2 = w.square();
                z = z.square().add(w2.multiply(t));
                w = w2.add(rhs);
                ++i;
            }
            if (w.isZero()) continue;
            return null;
        } while ((gamma = z.square().add(z)).isZero());
        return z;
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$math$ec$test$ECPointTest == null ? (class$org$bouncycastle$math$ec$test$ECPointTest = ECPointTest.class$("org.bouncycastle.math.ec.test.ECPointTest")) : class$org$bouncycastle$math$ec$test$ECPointTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class F2m {
        private final int m = 4;
        private final int k1 = 1;
        private final BigInteger aTpb = new BigInteger("1000", 2);
        private final BigInteger bTpb = new BigInteger("1001", 2);
        private final BigInteger n = new BigInteger("23");
        private final BigInteger h = new BigInteger("1");
        private final ECCurve.F2m curve = new ECCurve.F2m(4, 1, this.aTpb, this.bTpb, this.n, this.h);
        private final ECPoint.F2m infinity = (ECPoint.F2m)this.curve.getInfinity();
        private final String[] pointSource = new String[]{"0010", "1111", "1100", "1100", "0001", "0001", "1011", "0010"};
        private ECPoint[] p = new ECPoint[this.pointSource.length / 2];

        private void createPoints() {
            int i = 0;
            while (i < this.pointSource.length / 2) {
                this.p[i] = this.curve.createPoint(new BigInteger(this.pointSource[2 * i], 2), new BigInteger(this.pointSource[2 * i + 1], 2));
                ++i;
            }
        }
    }

    public static class Fp {
        private final BigInteger q = new BigInteger("1063");
        private final BigInteger a = new BigInteger("4");
        private final BigInteger b = new BigInteger("20");
        private final BigInteger n = new BigInteger("38");
        private final BigInteger h = new BigInteger("1");
        private final ECCurve curve = new ECCurve.Fp(this.q, this.a, this.b, this.n, this.h);
        private final ECPoint infinity = this.curve.getInfinity();
        private final int[] pointSource = new int[]{1, 5, 4, 10, 234, 1024, 817, 912};
        private ECPoint[] p = new ECPoint[this.pointSource.length / 2];

        private void createPoints() {
            int i = 0;
            while (i < this.pointSource.length / 2) {
                this.p[i] = this.curve.createPoint(new BigInteger(Integer.toString(this.pointSource[2 * i])), new BigInteger(Integer.toString(this.pointSource[2 * i + 1])));
                ++i;
            }
        }
    }
}

