/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.test.AllTests;
import org.bouncycastle.util.Times;

public class ECPointPerformanceTest
extends TestCase {
    static final int MILLIS_PER_ROUND = 200;
    static final int MILLIS_WARMUP = 1000;
    static final int MULTS_PER_CHECK = 16;
    static final int NUM_ROUNDS = 10;
    private static String[] COORD_NAMES = new String[]{"AFFINE", "HOMOGENEOUS", "JACOBIAN", "JACOBIAN-CHUDNOVSKY", "JACOBIAN-MODIFIED", "LAMBDA-AFFINE", "LAMBDA-PROJECTIVE", "SKEWED"};

    private void randMult(String curveName) throws Exception {
        X9ECParameters spec = ECNamedCurveTable.getByName((String)curveName);
        if (spec != null) {
            this.randMult(curveName, spec);
        }
        if ((spec = CustomNamedCurves.getByName((String)curveName)) != null) {
            this.randMult(curveName + " (custom)", spec);
        }
    }

    private void randMult(String label, X9ECParameters spec) throws Exception {
        ECCurve C = spec.getCurve();
        ECPoint G = spec.getG();
        BigInteger n = spec.getN();
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        random.setSeed(System.currentTimeMillis());
        System.out.println(label);
        int[] coords = ECCurve.getAllCoordinateSystems();
        int i = 0;
        while (i < coords.length) {
            int coord = coords[i];
            if (C.supportsCoordinateSystem(coord)) {
                boolean defaultCoord;
                ECCurve c = C;
                ECPoint g = G;
                boolean bl = defaultCoord = c.getCoordinateSystem() == coord;
                if (!defaultCoord) {
                    c = C.configure().setCoordinateSystem(coord).create();
                    g = c.importPoint(G);
                }
                double avgRate = this.randMult(random, g, n);
                String coordName = COORD_NAMES[coord];
                StringBuffer sb = new StringBuffer();
                sb.append("   ");
                sb.append(defaultCoord ? (char)'*' : ' ');
                sb.append(coordName);
                int j = sb.length();
                while (j < 30) {
                    sb.append(' ');
                    ++j;
                }
                sb.append(": ");
                sb.append(avgRate);
                sb.append(" mults/sec");
                int j2 = sb.length();
                while (j2 < 64) {
                    sb.append(' ');
                    ++j2;
                }
                sb.append('(');
                sb.append(1000.0 / avgRate);
                sb.append(" millis/mult)");
                System.out.println(sb.toString());
            }
            ++i;
        }
    }

    private double randMult(SecureRandom random, ECPoint g, BigInteger n) throws Exception {
        BigInteger[] ks = new BigInteger[128];
        int i = 0;
        while (i < ks.length) {
            ks[i] = new BigInteger(n.bitLength() - 1, random);
            ++i;
        }
        int ki = 0;
        ECPoint p = g;
        long startTime = Times.nanoTime();
        long goalTime = startTime + 1000000000L;
        do {
            BigInteger k = ks[ki];
            p = g.multiply(k);
            if ((ki & 1) != 0) {
                g = p;
            }
            if (++ki != ks.length) continue;
            ki = 0;
        } while (Times.nanoTime() < goalTime);
        double minRate = Double.MAX_VALUE;
        double maxRate = Double.MIN_VALUE;
        double totalRate = 0.0;
        int i2 = 1;
        while (i2 <= 10) {
            long endTime;
            long startTime2 = Times.nanoTime();
            long goalTime2 = startTime2 + 200000000L;
            long count = 0L;
            do {
                ++count;
                int j = 0;
                while (j < 16) {
                    BigInteger k = ks[ki];
                    p = g.multiply(k);
                    if ((ki & 1) != 0) {
                        g = p;
                    }
                    if (++ki == ks.length) {
                        ki = 0;
                    }
                    ++j;
                }
            } while ((endTime = Times.nanoTime()) < goalTime2);
            double roundElapsed = endTime - startTime2;
            double roundRate = (double)(count * 16L * 1000000000L) / roundElapsed;
            minRate = Math.min(minRate, roundRate);
            maxRate = Math.max(maxRate, roundRate);
            totalRate += roundRate;
            ++i2;
        }
        return (totalRate - minRate - maxRate) / 8.0;
    }

    public void testMultiply() throws Exception {
        TreeSet names = new TreeSet(AllTests.enumToList(ECNamedCurveTable.getNames()));
        names.addAll(AllTests.enumToList(CustomNamedCurves.getNames()));
        HashSet<ASN1ObjectIdentifier> oids = new HashSet<ASN1ObjectIdentifier>();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ASN1ObjectIdentifier oid = ECNamedCurveTable.getOID((String)name);
            if (oid == null) {
                oid = CustomNamedCurves.getOID((String)name);
            }
            if (oid != null && !oids.add(oid)) continue;
            this.randMult(name);
        }
    }
}

